sampler sTextureZ;
sampler sTextureLUT;
sampler sTextureFrame;
sampler sTextureFrameBlurred;

float4 main( float4 inDiffuse: COLOR0, float2 tex : TEXCOORD0 ) : COLOR0
{
	float4 pixZ             = tex2D( sTextureZ           , tex );
	float4 pixLUT           = tex2D( sTextureLUT         , pixZ.gb );
	float4 pixFrame         = tex2D( sTextureFrame       , tex );
	float4 pixFrameBlurred  = tex2D( sTextureFrameBlurred, tex );
		
	float4 color = lerp( pixFrameBlurred, pixFrame, pixLUT );
	
	return color;
}
