sampler TextureZData: register(s0);
sampler TextureAlphaLookup: register(s1);
sampler TextureClear: register(s2);
sampler TextureBlured: register(s3);

float4 main( float4 inDiffuse: COLOR0, 
		     float2 Tex0 : TEXCOORD0,
		     float2 Tex1 : TEXCOORD1,
		     float2 Tex2 : TEXCOORD2,
		     float2 Tex3 : TEXCOORD3 ) : COLOR0
{
	float4 z_texel = tex2D( TextureZData, Tex 0);
	
	float2 uv;
	
	uv.x = z_texel.g;
	uv.y = z_texel.b;
	
	float4 alpha = tex2D( TextureAlphaLookup, uv );
	
	float4 c1 = tex2D( TextureClear, Tex2 );
	float4 c2 = tex2D( TextureBlured, Tex3 );
	
	return lerp( c1, c2, alpha );
}



