sampler TextureSrc: register(s0);
sampler TextureBlured: register(s1);
sampler TextureZData: register(s2);
sampler TextureAlphaLookup: register(s3);
sampler TextureZSrc: register(s4);
sampler TextureZDst: register(s5);
float   lerp_factor:register(c0);
float4 main( float4 inDiffuse: COLOR0, float2 Tex : TEXCOORD0 ) : COLOR0
{
	float2 uv 	 = { 0.0f, 0.0f };
	float4 z_src = tex2D( TextureZSrc, uv );
	float4 z_dst = tex2D( TextureZDst, uv );
		
	float4 curve_id = lerp( z_src, z_dst, lerp_factor );
	
	//
	// Fetch the Z Value at specified UV ( simulate the u,v of the camera
	//float4 texel_z  = tex2D( TextureZData, Tex );
	//float4 curve_id = tex2D( TextureZData, uv );
	
	float4 texel_z = tex2D( TextureZData, Tex );
	
	//return texel_z;
		
	//
	// Fetch the Alpha blend value
	// U = 1.0 - z_value
	// V = focus_value;
	//

	//float2 uv;
	uv.x = 1.0 - texel_z.y;
	uv.y = 1.0 - curve_id.x;

	float4 blend_value = tex2D( TextureAlphaLookup, uv ); 

	float4 texel_src = tex2D( TextureSrc, Tex );
	float4 texel_blr = tex2D( TextureBlured, Tex );

	float4 color = lerp( texel_src, texel_blr, 1.0 - blend_value.x );

	return color;
}



