/* Jellybean Fugue 1.0
   Copyright (c) 2004 Phillip Nguyen

   Jellybean Fugue is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License or (at your option) any later version.  

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jellybean Fugue; see the file COPYING. If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info:
   nguyenp@eecs.tulane.edu
*/
#define DEG_TO_RAD   0.01745329252
#define RAD_TO_DEG   57.2957795131

typedef struct {
    float x;
    float y;
} Vector2;

typedef struct {
    Vector2 v1;
    Vector2 v2;
} Edge;

extern void vector_add(Vector2 *v, Vector2 *w, Vector2 *dest);
extern void vector_sub(Vector2 *v, Vector2 *w, Vector2 *dest);
extern void vector_scale(float c, Vector2 *v, Vector2 *dest);
extern float vector_dot(Vector2 *v, Vector2 *w);
extern float vector_length(Vector2 *v);
extern void vector_normalize(Vector2 *v, Vector2 *dest);
extern void vector_rotate(Vector2 *v, float angle, Vector2 *dest);
extern float vector_angle(Vector2 *v);
extern void edge_rotate(Edge *e, float angle, Edge *dest);
extern void edge_translate(Edge *e, Vector2 *delta, Edge *dest);
extern void edge_normal(Edge *e, Vector2 *normal);

extern int circle_intersects_segment(Vector2 *p, float radius, Vector2 *x1, Vector2 *x2);
extern int check_moving_circle_against_edge(Vector2 *p, Vector2 *delta, float radius, Edge *e);
extern int check_moving_point_against_edge(Vector2 *p, Vector2 *delta, Edge *edge);
extern int check_moving_point_against_circle(Vector2 *p, Vector2 *delta, Vector2 *center, float radius);
int ray_intersects_edge(Vector2 *p, Vector2* delta, Edge *edge, float *collisionTime);


