/* Jellybean Fugue 1.0
   Copyright (c) 2004 Phillip Nguyen

   Jellybean Fugue is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License or (at your option) any later version.  

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jellybean Fugue; see the file COPYING. If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info:
   nguyenp@eecs.tulane.edu
*/
#import <OpenGL/gl.h>
#import "Ship.h"
#import "GameController.h"
#import "ParticleEngine.h"
#import "Utility.h"
#import "Bullet.h"


#define SHIP_MAX_SPEED  300.0


@implementation Ship

- (id)initInMap:(GameMap *)map
{
    self = [super initInMap:map];
    _boundingRadius = 16;
    _shieldEnergy = 5;
    _color[0] = 0;
    _color[1] = 255;
    _color[2] = 0;
    return self;
}

- (float)boundingRadius 
{ 
    if (_shield) return _shieldRadius;
    return _boundingRadius; 
}

- (void)takeDamage:(int)damage
{
    if (_shield) return;
    [super takeDamage:damage];
}

- (void)rotateLeft:(float)deltaTime
{ 
    _angle += _omega * deltaTime; 
}

- (void)rotateRight:(float)deltaTime
{ 
    _angle -= _omega * deltaTime; 
}

- (void)accelerateForward
{
    _v.x = SHIP_MAX_SPEED * cos(_angle * DEG_TO_RAD);
    _v.y = SHIP_MAX_SPEED * sin(_angle * DEG_TO_RAD);
    _showExhaust = YES;
}

- (void)accelerateBackward
{
    _v.x = -SHIP_MAX_SPEED * cos(_angle * DEG_TO_RAD);
    _v.y = -SHIP_MAX_SPEED * sin(_angle * DEG_TO_RAD);
    _showExhaust = NO;
}

- (void)brake
{
    _v.x *= 0.9;
    _v.y *= 0.9;
    _showExhaust = NO;
}

- (void)fireWeapon
{
    static float strobe = 0;
    strobe += 0.1;
    //GLubyte red = 192 + 63*sin(strobe);
    //GLubyte blue = 192 - 63*sin(strobe);

    float c = cos(_angle * DEG_TO_RAD);
    float s = sin(_angle * DEG_TO_RAD);

    Vector2 vel = { 500.0*c + _v.x, 500.0*s + _v.y };

    float startx = _boundingRadius + 3*sin(strobe) - 3;
    Vector2 pos = { startx*c + _x.x, startx*s + _x.y };

    [[_map gameController] addBullet:[Bullet bulletInMap:_map
					     withPosition:&pos
					     velocity:&vel
					     orientation:_angle]];

}

- (void)activateShield
{
    if (!_shield && _shieldEnergy > 0) {
	_shield = YES;
	_shieldRadius = 5.0;
    }
}

- (void)deactivateShield
{
    _shield = NO;
}

- (void)addToShieldEnergy:(float)energy
{
    _shieldEnergy += energy;
}

- (void)run:(float)deltaTime
{
    [super run:deltaTime];

    static float shieldThrob = 0;

    if (_showExhaust) {
	float c = cos(_angle * DEG_TO_RAD);
	float s = sin(_angle * DEG_TO_RAD);
	int i;
	for (i = 0; i < 4; i++) {
	    float dy = randomFloatBetween(-4.0,4.0);
	    float x = _x.x - 12*c - dy*s;
	    float y = _x.y - 12*s + dy*c;
	    float v = -(4.0-ABS(dy))/3.0;
	    [[ParticleEngine sharedParticleEngine] addParticleWithPosition:x:y 
						   velocity:v*_v.x:v*_v.y
						   color:0xff:0xff:0
						   timer:1
						   fade:YES];
	}
    }

    if (_shield) {
	if (_shieldRadius >= 47) {
	    _shieldRadius = 50 - 3*cos(10*shieldThrob);
	    shieldThrob += deltaTime;
	} else {
	    _shieldRadius += 2.0;
	    if (_shieldRadius >= 47.0) {
		_shieldRadius = 47.0;
		shieldThrob = 0;
	    }
	}
	_shieldEnergy -= deltaTime;
	if (_shieldEnergy <= 0) {
	    [self deactivateShield];
	}
    } 
}

- (void)draw
{
    glPushMatrix();
    glTranslatef(_x.x, _x.y, 0);

    // Display the HP meter before rotating so that
    // it will always appear below the unit.
    if (_displayHPMeter) {
	[self drawHPMeter];
    }

    glRotatef(_angle, 0, 0, 1);

    glColor3f(0,1.0,0.2);
    glBegin(GL_LINE_LOOP);
    glVertex2f( 20,  0);
    glVertex2f(-10, 15);
    glVertex2f( -2,  3);
    glVertex2f( -2, -3);
    glVertex2f(-10,-15);
    glEnd();
    glColor3f(1,1,0);
    glBegin(GL_LINE_STRIP);
    glVertex2f( -6,  9);
    glVertex2f(-12,  4);
    glVertex2f(-12, -4);
    glVertex2f( -6, -9);
    glEnd();

    if (_shield) {
	float alpha = _shieldEnergy / 0.5;
	if (alpha > 1) alpha = 1;
	glColor4f(0.4,1,1,alpha);
	glBegin(GL_LINE_LOOP);
	int i, n = 10;
	float r = _shieldRadius;
	float theta = 0;
	float dTheta = 2*M_PI/(float)n;
	for (i = 0; i < n; i++, theta += dTheta) {
	    glVertex2f(r*cos(theta), r*sin(theta));
	}
	glEnd();
    }

    glPopMatrix();
}

- (void)explode 
{
    [[ParticleEngine sharedParticleEngine] addExplosionAtPoint:&_x withColor:_color];
}

@end
