/* Jellybean Fugue 1.0
   Copyright (c) 2004 Phillip Nguyen

   Jellybean Fugue is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License or (at your option) any later version.  

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jellybean Fugue; see the file COPYING. If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info:
   nguyenp@eecs.tulane.edu
*/
#import "GameUnit.h"


@interface Ship : GameUnit
{
    BOOL _showExhaust;     // spray particles from engine?
    BOOL _shield;          // is the shield activated?
    float _shieldEnergy;   // how long can the shield last?
    float _shieldRadius;   // current size of shield
    
    float _reloadTimer;    // how long before we can fire again?
    float _timeToReload;   // time it takes to reload the weapon (constant)
}
- (void)rotateLeft:(float)deltaTime;
- (void)rotateRight:(float)deltaTime;
- (void)accelerateForward;
- (void)accelerateBackward;
- (void)brake;
- (void)fireWeapon;
- (void)activateShield;
- (void)deactivateShield;
- (void)addToShieldEnergy:(float)energy;
@end
