/* Jellybean Fugue 1.0
   Copyright (c) 2004 Phillip Nguyen

   Jellybean Fugue is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License or (at your option) any later version.  

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jellybean Fugue; see the file COPYING. If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info:
   nguyenp@eecs.tulane.edu
*/
#import "ParticleEngine.h"
#import "Utility.h"


@implementation Particle
@end

@implementation LineSegment
@end

@implementation ParticleEngine

+ (ParticleEngine *)sharedParticleEngine
{
    static ParticleEngine *myParticleEngine = nil;
    if (myParticleEngine == nil) {
	myParticleEngine = [[ParticleEngine alloc] init];
    }
    return myParticleEngine;
}

- (id)init
{
    self = [super init];

    m_particles = [[NSMutableArray alloc] initWithCapacity:1024];
    m_lines = [[NSMutableArray alloc] initWithCapacity:1024];
    return self;
}

- (void)dealloc
{
    [m_particles release];
    [m_lines release];
    [super dealloc];
}

- (void)addParticleWithPosition:(float)x :(float)y velocity:(float)vx :(float)vy color:(GLubyte)red :(GLubyte)green :(GLubyte)blue timer:(float)timer fade:(BOOL)fade
{
    Particle *p = [[Particle alloc] init];
    p->x = x;
    p->y = y;
    p->vx = vx;
    p->vy = vy;
    p->color[0] = red;
    p->color[1] = green;
    p->color[2] = blue;
    p->color[3] = 0xff;
    p->timer = timer;
    p->fade = fade;
    [m_particles addObject:p];
    [p release];
}

- (void)addLineWithPosition:(float)x1 :(float)y1 :(float)x2 :(float)y2 velocity:(float)vx :(float)vy color:(GLubyte)red :(GLubyte)green :(GLubyte)blue timer:(float)timer fade:(BOOL)fade
{
    LineSegment *s = [[LineSegment alloc] init];
    s->x1 = x1;
    s->y1 = y1;
    s->x2 = x2;
    s->y2 = y2;
    s->vx = vx;
    s->vy = vy;
    s->color[0] = red;
    s->color[1] = green;
    s->color[2] = blue;
    s->color[3] = 0xff;
    s->timeToLive = timer;
    s->fade = fade;
    [m_lines addObject:s];
    [s release];
}

- (void)addEdge:(Edge *)e withVelocity:(Vector2 *)v color:(GLubyte)red :(GLubyte)green :(GLubyte)blue timer:(float)timer fade:(BOOL)fade
{
    LineSegment *s = [[LineSegment alloc] init];
    s->x1 = e->v1.x;
    s->y1 = e->v1.y;
    s->x2 = e->v2.x;
    s->y2 = e->v2.y;
    s->vx = v->x;
    s->vy = v->y;
    s->color[0] = red;
    s->color[1] = green;
    s->color[2] = blue;
    s->color[3] = 0xff;
    s->timeToLive = timer;
    s->fade = fade;
    [m_lines addObject:s];
    [s release];
}

- (void)addExplosionAtPoint:(Vector2 *)p withColor:(GLubyte *)color
{
    int i;
    for (i = 0; i < 50; i++) {
	Vector2 vel = { randomFloatBetween(20, 100), 0 };
	float theta = randomFloatBetween(0, 2*M_PI);
	float length = randomFloatBetween(10,20);
	Edge edge = { {10, length}, {10, -length} };
	vector_rotate(&vel, theta, &vel);
	edge_rotate(&edge, theta, &edge);
	edge_translate(&edge, p, &edge);
	[self addEdge:&edge 
	      withVelocity:&vel
	      color:color[0]:color[1]:color[2]
	      timer:2
	      fade:YES];
    }
}

- (int)count { return [m_particles count]; }

- (void)run:(float)deltaTime
{
    int index = [m_particles count];
    while (index--) {
	Particle *p = [m_particles objectAtIndex:index];
	p->x += p->vx * deltaTime;
	p->y += p->vy * deltaTime;
	if (p->fade) p->color[3] *= 0.9;
	p->timer -= deltaTime;
	if (p->timer < 0) {
	    [m_particles removeObjectAtIndex:index];
	}
    }

    index = [m_lines count];
    while (index--) {
	LineSegment *s = [m_lines objectAtIndex:index];
	s->x1 += s->vx * deltaTime;
	s->y1 += s->vy * deltaTime;
	s->x2 += s->vx * deltaTime;
	s->y2 += s->vy * deltaTime;
	if (s->fade) {
	    float alpha;
	    if (2*s->timer < s->timeToLive) alpha = 0.5;
	    else alpha = ((s->timeToLive - s->timer) / s->timeToLive);
	    s->color[3] = 0xff * alpha; 
	}
	s->timer += deltaTime;
	if (s->timer >= s->timeToLive) {
	    [m_lines removeObjectAtIndex:index];
	}
    }
}

- (void)draw
{
    glBegin(GL_POINTS);
    int index = [m_particles count];
    while (index--) {
	Particle *p = [m_particles objectAtIndex:index];
	glColor4ubv(p->color);
	glVertex2f(p->x, p->y);
    }    
    glEnd();

    glBegin(GL_LINES);
    index = [m_lines count];
    while (index--) {
	LineSegment *s = [m_lines objectAtIndex:index];
	glColor4ubv(s->color);
	glVertex2f(s->x1, s->y1);
	glVertex2f(s->x2, s->y2);
    }    
    glEnd();
}

@end
