/* Jellybean Fugue 1.0
   Copyright (c) 2004 Phillip Nguyen

   Jellybean Fugue is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License or (at your option) any later version.  

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jellybean Fugue; see the file COPYING. If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info:
   nguyenp@eecs.tulane.edu
*/
#import <Foundation/Foundation.h>
#import <OpenGL/gl.h>
#import "Vector2.h"

@interface Particle : NSObject
{
@public
    float x, y;        // position of particle
    float vx, vy;      // velocity of particle
    GLubyte color[4];  // current color
    float timer;       // time to live
    BOOL fade;         // does the particle fade away?
}
@end

@interface LineSegment : NSObject
{
@public
    float x1, y1;      // begin point of line
    float x2, y2;      // end point of line
    float vx, vy;      // velocity of line
    GLubyte color[4];  // current color
    float timeToLive;  // time to live
    float timer;       // lifetime so far
    BOOL fade;         // does the particle fade away?
}
@end

@interface ParticleEngine : NSObject
{
    NSMutableArray *m_particles;
    NSMutableArray *m_lines;
}
+ (ParticleEngine *)sharedParticleEngine;
- (void)addParticleWithPosition:(float)x :(float)y velocity:(float)vx :(float)vy color:(GLubyte)red :(GLubyte)green :(GLubyte)blue timer:(float)timer fade:(BOOL)fade;
- (void)addLineWithPosition:(float)x1 :(float)y1 :(float)x2 :(float)y2 velocity:(float)vx :(float)vy color:(GLubyte)red :(GLubyte)green :(GLubyte)blue timer:(float)timer fade:(BOOL)fade;
- (void)addEdge:(Edge *)e withVelocity:(Vector2 *)v color:(GLubyte)red :(GLubyte)green :(GLubyte)blue timer:(float)timer fade:(BOOL)fade;
- (void)addExplosionAtPoint:(Vector2 *)p withColor:(GLubyte *)color;
- (int)count;
- (void)run:(float)deltaTime;
- (void)draw;
@end
