/* Jellybean Fugue 1.0
   Copyright (c) 2004 Phillip Nguyen

   Jellybean Fugue is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License or (at your option) any later version.  

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jellybean Fugue; see the file COPYING. If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info:
   nguyenp@eecs.tulane.edu
*/
#import <OpenGL/gl.h>
#import "Jellybean.h"
#import "Ship.h"
#import "GameController.h"
#import "ParticleEngine.h"


@implementation Jellybean

+ (Jellybean *)randomBeanWithPosition:(Vector2 *)p inMap:(GameMap *)map
{
    Jellybean *bean;
    switch (random()%3) {
    case 0: bean = [[Jellybean alloc] initInMap:map]; break;
    case 1: bean = [[Lifebean alloc] initInMap:map]; break;
    case 2: bean = [[Shieldbean alloc] initInMap:map]; break;
    }
    bean->_x.x = p->x;
    bean->_x.y = p->y;
    [bean setOrientation:randomFloatBetween(0,360)];
    return [bean autorelease];
}

- (id)initInMap:(GameMap *)map
{
    self = [super initInMap:map];

    _boundingRadius = 16;
    _omega = randomFloatBetween(50, 180);
    if (random()%2 == 0) _omega *= -1;

    GLubyte colors[][3] = { {255,0,0}, {0,0,255}, {255,0,255}, {255,255,0} };
    int i = random()%4;
    _color[0] = colors[i][0];
    _color[1] = colors[i][1];
    _color[2] = colors[i][2];
    _color[3] = 255;

    return self;
}

- (void)run:(float)deltaTime
{
    // Rotate.
    _angle += _omega * deltaTime;

    // Check for collision with the player's ship.
    Ship *ship = [[_map gameController] ship];
    Vector2 delta = { 0, 0 };
    if (check_moving_point_against_circle([ship position], &delta, &_x, _boundingRadius)) {
	_isDead = YES;
	[[_map gameController] addToScore:100];
	[self explode];
    }
}

- (void)draw
{
    glPushMatrix();
    glTranslatef(_x.x, _x.y, 0);
    glRotatef(_angle, 0, 0, 1);

    const GLfloat vertices[8][2] = { {6,4}, {8,10}, {3,13}, {-6,7},
				     {-6,-7}, {3,-13}, {8,-10}, {6,-4} };
   
    glEnableClientState(GL_VERTEX_ARRAY);
    glVertexPointer(2, GL_FLOAT, 0, vertices);
    glColor4ubv(_color);
    glDrawArrays(GL_LINE_LOOP, 0, 8);
    glDisableClientState(GL_VERTEX_ARRAY);

    glPopMatrix();
}

- (void)explode
{
    float radAngle = _angle * DEG_TO_RAD;
    Vector2 v[8] = { {6,4}, {8,10}, {3,13}, {-6,7},
		     {-6,-7}, {3,-13}, {8,-10}, {6,-4} };
    int i;
    for (i = 0; i < 8; i++) {
	vector_rotate(&v[i], radAngle, &v[i]);
	vector_add(&v[i], &_x, &v[i]);
    }
    Edge e[8] = { {v[0],v[1]}, {v[1],v[2]}, {v[2],v[3]}, {v[3],v[4]},
		  {v[4],v[5]}, {v[5],v[6]}, {v[6],v[7]}, {v[7],v[0]} };
    float angles[8] = { 45, 64.4, 98.5, 180, -98.5, -64.4, -45, 0 };
    for (i = 0; i < 8; i++) {
	Vector2 vel = {25, 0};
	vector_rotate(&vel, angles[i]*DEG_TO_RAD + radAngle, &vel);
	[[ParticleEngine sharedParticleEngine] addEdge:&e[i] 
					       withVelocity:&vel
					       color:_color[0]:_color[1]:_color[2]
					       timer:2
					       fade:YES];
    }
}

@end

//////////////////////////////////////////////////////////////////////

@implementation Lifebean

- (id)initInMap:(GameMap *)map
{
    self = [super initInMap:map];
    _color[0] = 0;
    _color[1] = 255;
    _color[2] = 0;
    _color[3] = 255;
    return self;
}

- (void)run:(float)deltaTime
{
    // Rotate.
    _angle += _omega * deltaTime;

    // Check for collision with the player's ship.
    Ship *ship = [[_map gameController] ship];
    Vector2 delta = { 0, 0 };
    if (check_moving_point_against_circle([ship position], &delta, &_x, _boundingRadius)) {
	_isDead = YES;
	[[_map gameController] addToScore:100];
	[ship addToLife:1];
	[self explode];
    }
}

@end

//////////////////////////////////////////////////////////////////////

@implementation Shieldbean

- (id)initInMap:(GameMap *)map
{
    self = [super initInMap:map];
    _color[0] = 0;
    _color[1] = 255;
    _color[2] = 255;
    _color[3] = 255;
    return self;
}

- (void)run:(float)deltaTime
{
    // Rotate.
    _angle += _omega * deltaTime;

    // Check for collision with the player's ship.
    Ship *ship = [[_map gameController] ship];
    Vector2 delta = { 0, 0 };
    if (check_moving_point_against_circle([ship position], &delta, &_x, _boundingRadius)) {
	_isDead = YES;
	[[_map gameController] addToScore:100];
	[ship addToShieldEnergy:1.5];
	[self explode];
    }
}

@end

//////////////////////////////////////////////////////////////////////

@implementation Levelbean

- (id)initInMap:(GameMap *)map
{
    self = [super initInMap:map];
    _boundingRadius = 32;
    _omega = 180;
    if (random()%2 == 0) _omega *= -1;
    return self;
}

- (void)run:(float)deltaTime
{
    // Rotate.
    _angle += _omega * deltaTime;

    // Check for collision with the player's ship.
    Ship *ship = [[_map gameController] ship];
    Vector2 delta = { 0, 0 };
    if (check_moving_point_against_circle([ship position], &delta, &_x, _boundingRadius)) {
	_isGrowing = YES;

    }
    if (_isGrowing) {
	_boundingRadius += 4;
	if (_boundingRadius > 256) {
	    _isDead = YES;
	    [[_map gameController] startNewLevel];
	}
    }
}

- (void)draw
{
    glPushMatrix();
    glTranslatef(_x.x, _x.y, 0);
    glRotatef(_angle, 0, 0, 1);
    glColor4ubv(_color);

    if (_isGrowing) {
	glBegin(GL_LINE_STRIP);
	float t;
	for (t = 0; t < _boundingRadius; t += 0.5) {
	    glVertex2f(t*cos(t), t*sin(t));
	}
	glEnd();
    } else {
	const GLfloat vertices[32][2] = { {0.000000,0.000000}, {0.540302,0.841471}, {-0.832294,1.818595}, {-2.969977,0.423360},
					  {-2.614574,-3.027210}, {1.418311,-4.794621}, {5.761022,-1.676493}, {5.277316,4.598906},
					  {-1.164000,7.914866}, {-8.200172,3.709066}, {-8.390715,-5.440211}, {0.048683,-10.999892},
					  {10.126248,-6.438875}, {11.796808,5.462171}, {1.914321,13.868503}, {-11.395319,9.754318},
					  {-15.322552,-4.606453}, {-4.677777,-16.343757}, {11.885701,-13.517770}, {18.785388,2.847667},
					  {8.161641,18.258905}, {-11.502314,17.569768}, {-21.999138,-0.194729}, {-12.255159,-19.463069},
					  {10.180296,-21.733881}, {24.780070,-3.308794}, {16.819902,19.826520}, {-7.887748,25.822150},
					  {-26.952964,7.585362}, {-21.693668,-19.245383}, {4.627543,-29.640949}, {28.357013,-12.525167} };
	
	glEnableClientState(GL_VERTEX_ARRAY);
	glVertexPointer(2, GL_FLOAT, 0, vertices);
	glDrawArrays(GL_LINE_STRIP, 0, 32);
	glDisableClientState(GL_VERTEX_ARRAY);
    }
    
    glPopMatrix();

}

@end
