/* Jellybean Fugue 1.0
   Copyright (c) 2004 Phillip Nguyen

   Jellybean Fugue is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License or (at your option) any later version.  

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jellybean Fugue; see the file COPYING. If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info:
   nguyenp@eecs.tulane.edu
*/
#import <Foundation/Foundation.h>
#import "Vector2.h"


// The HexMazeCoord class is used only in generating the maze.
// We just need an ObjC type object that can be contained
// in an NSArray, and using NSValue seemed a bit ugly.
@interface HexMazeCoord : NSObject
{
@public
    int x, y;
}
+ (HexMazeCoord *)coord:(int)initX :(int)initY;
@end

typedef struct {
    BOOL condemned;
    BOOL visited;
    BOOL exits[6]; // enumerated clockwise from upper-left side.
} HexMazeCell;

@interface HexMaze : NSObject
{
    unsigned _width;
    unsigned _height;
    unsigned _size;
    HexMazeCell *_data;
}
- (id)initWithSize:(NSSize)size;
- (void)clearMaze;
- (void)createRandomMaze;
- (HexMazeCell *)cellAtCoord:(HexMazeCoord *)coord;
- (int)edgeList:(Edge **)edgeArray withCellRadius:(const float)cellRadius;
@end
    
