/* Jellybean Fugue 1.0
   Copyright (c) 2004 Phillip Nguyen

   Jellybean Fugue is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License or (at your option) any later version.  

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jellybean Fugue; see the file COPYING. If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info:
   nguyenp@eecs.tulane.edu
*/
#import <Foundation/Foundation.h>
#import <OpenGL/gl.h>
#import "Vector2.h"
#import "GameMap.h"


@interface GameUnit : NSObject
{
    Vector2 _x;              // position
    Vector2 _v;              // velocity
    float _angle;            // orientation
    float _omega;            // angular velocity
    GLubyte _color[3];       // color of the unit

    GameMap *_map;           // map in which unit resides

    float _boundingRadius;   // radius of bounding sphere

    int _hitPoints;          // quantized life of unit
    int _maxHitPoints;       // maximum life
    BOOL _hitSomething;      // did we hit something while moving?
    BOOL _isDead;            // is the unit dead?

    BOOL _displayHPMeter;    // should we show the HP meter?
    float _displayTimer;     // for how long do we show the HP meter?
}
- (id)initInMap:(GameMap *)map;
- (void)setMap:(GameMap *)map;
- (void)setPosition:(float)x :(float)y;
- (void)setOrientation:(float)angle;
- (void)setBoundingRadius:(float)radius;
- (float)x;
- (float)y;
- (float)angle;
- (Vector2 *)position;
- (float)boundingRadius;
- (BOOL)isDead;
- (BOOL)canBeHitByBullets;
- (BOOL)moveBy:(float)dx :(float)dy;
- (void)rotateBy:(float)dtheta;
- (void)run:(float)deltaTime;
- (void)draw;
- (void)explode;
- (void)takeDamage:(int)damage;
- (void)addToLife:(int)points;
- (void)drawHPMeter;
@end
