/* Jellybean Fugue 1.0
   Copyright (c) 2004 Phillip Nguyen

   Jellybean Fugue is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License or (at your option) any later version.  

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jellybean Fugue; see the file COPYING. If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info:
   nguyenp@eecs.tulane.edu
*/
#import <OpenGL/gl.h>
#import "GameMap.h"
#import "GameController.h"
#import "HexMaze.h"


@implementation GameMap
- (id)initWithSize:(NSSize)size gameController:(GameController *)gc
{
    self = [super init];

    _gameController = gc;

    // Create the environment.
    _width = size.width;
    _height = size.height;
    _cellRadius = 200;
    HexMaze *maze = [[HexMaze alloc] initWithSize:size];
    [maze createRandomMaze];
    _numWalls = [maze edgeList:&_walls withCellRadius:_cellRadius];
    [maze release];

    _wallFlags = (BOOL *)malloc(_numWalls*sizeof(BOOL));
    int i;
    for (i = 0; i < _numWalls; i++) _wallFlags[i] = NO;
    return self;
}

- (void)dealloc
{
    free(_walls);
    free(_wallFlags);
    [super dealloc];
}

- (GameController *)gameController { return _gameController; }
- (int)numberOfWalls { return _numWalls; }
- (Edge *)walls { return _walls; }

// This does no error checking to see if (i,j) is within the maze.
- (NSPoint)centerOfCell:(int)i:(int)j
{
    const float hexHeight = 1.73205080757*_cellRadius;  // = cellRadius*sqrt(3)
    const float yOffset = -(float)(_height/2)*hexHeight;
    const float xOffset = -(float)(_width/2)*1.5*_cellRadius;
    int odd = i % 2;
    float x = 1.5*i*_cellRadius + xOffset;
    float y = j*hexHeight + yOffset - odd*hexHeight/2.0;
    return NSMakePoint(x, y);
}

- (NSPoint)randomPointWithinMaze
{
    const float hexHeight = 1.73205080757*_cellRadius;  // = cellRadius*sqrt(3)
    const float wallJitter = 30;  // used to break up monotony of walls

    int i = random()%_width;
    int j = random()%_height;

    NSPoint p = [self centerOfCell:i:j];
    float r = randomFloatBetween(0, 0.5*hexHeight - wallJitter);
    float theta = randomFloatBetween(0, 2*M_PI);
    p.x += r*cos(theta);
    p.y += r*sin(theta);
    return p;
}

- (void)clearWallFlags
{
    bzero(_wallFlags, _numWalls*sizeof(BOOL));
}

- (void)setWallFlagWithIndex:(int)index toValue:(BOOL)value
{
    _wallFlags[index] = value;
}

- (void)draw 
{
    int i;
    glBegin(GL_LINES);
    for (i = 0; i < _numWalls; i++) {
	if (_wallFlags[i]) {
	    glColor3f(1,0.4,1);
	} else {
	    glColor3f(0.4,0.4,1);
	}
	glVertex2f(_walls[i].v1.x, _walls[i].v1.y);
	glVertex2f(_walls[i].v2.x, _walls[i].v2.y);
    }
    glEnd();
}

@end
