/* Jellybean Fugue 1.0
   Copyright (c) 2004 Phillip Nguyen

   Jellybean Fugue is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License or (at your option) any later version.  

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jellybean Fugue; see the file COPYING. If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info:
   nguyenp@eecs.tulane.edu
*/
#import <Foundation/Foundation.h>
#import "Vector2.h"


@class GameController;

@interface GameMap : NSObject
{
    GameController *_gameController;
    Edge *_walls;
    int _numWalls;
    BOOL *_wallFlags;

    int _width;
    int _height;
    float _cellRadius;
}
- (id)initWithSize:(NSSize)size gameController:(GameController *)gc;
- (GameController *)gameController;
- (int)numberOfWalls;
- (Edge *)walls;
- (NSPoint)centerOfCell:(int)i:(int)j;
- (NSPoint)randomPointWithinMaze;
- (void)clearWallFlags;
- (void)setWallFlagWithIndex:(int)index toValue:(BOOL)value;
- (void)draw;
@end
