/* Jellybean Fugue 1.0
   Copyright (c) 2004 Phillip Nguyen

   Jellybean Fugue is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License or (at your option) any later version.  

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jellybean Fugue; see the file COPYING. If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info:
   nguyenp@eecs.tulane.edu
*/
#import <Cocoa/Cocoa.h>
#import "Utility.h"
#import "Vector2.h"


@class GameView;
@class GameMap;
@class Ship;
@class Bullet;

#define NUM_WALLS 500

@interface GameController : NSObject
{
    GameView *view;
    GameMap *map;
    Ship *ship;

    NSMutableArray *unitList;
    NSMutableArray *bulletList;

    unsigned char keys[128];
    double _time;
    float _zoomFactor;
    float _zoomLevel;
    BOOL _cameraFollowsShip;

    BOOL _paused;

    unsigned _score;
    unsigned _pointsToBeAdded;
    BOOL _startNewLevel;

    NSString *_message;
    BOOL _displayMessage;
    float _messageTimer;
    BOOL _gameOver;

    int _level;
}
- (IBAction)startNewGame:(id)sender;
- (IBAction)toggleFullScreen:(id)sender;
- (IBAction)toggleShowFPS:(id)sender;
- (IBAction)togglePause:(id)sender;

- (void)createMapForCurrentLevel;

- (void)keyDown:(NSEvent *)event;
- (void)keyUp:(NSEvent *)event;
- (void)flagsChanged:(NSEvent *)event;
- (void)initializeOpenGL;
- (void)tabulaRasa;
- (void)run;
- (void)draw;

- (void)addBullet:(Bullet *)bullet;
- (NSMutableArray *)unitList;
- (Ship *)ship;
- (void)addToScore:(int)points;
- (void)startNewLevel;
@end
