/* Jellybean Fugue 1.0
   Copyright (c) 2004 Phillip Nguyen

   Jellybean Fugue is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License or (at your option) any later version.  

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jellybean Fugue; see the file COPYING. If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info:
   nguyenp@eecs.tulane.edu
*/
#import "EnemyShip.h"
#import "ParticleEngine.h"
#import "Utility.h"
#import "EnemyBullet.h"
#import "GameController.h"
#import "Jellybean.h"


@implementation EnemyShip

- (id)initInMap:(GameMap *)map
{
    self = [super initInMap:map];
    _timeToReload = 0.3;

    GLubyte colors[][3] = { {255,0,0},       // red
			    {255,228,225},   // misty rose
			    {255,165,0},     // orange
			    {255,255,0},     // yellow
			    {255,215,0},     // gold
			    {0,0,255},       // blue
			    {135,206,255},   // sky blue
			    {64,224,208},    // turquoise
			    {160,32,240},    // purple
			    {238,130,238},   // violet
			    {255,105,180} }; // hot pink

    int i = random()%11;
    _color[0] = colors[i][0];
    _color[1] = colors[i][1];
    _color[2] = colors[i][2];

    _maxHitPoints = 25;
    _hitPoints = _maxHitPoints;
    return self;
}

- (BOOL)canBeHitByBullets { return YES; }

- (void)fireWeapon
{
    // Don't fire weapon unless it's had enough time to recharge.
    if (_reloadTimer > 0) return;
    _reloadTimer = _timeToReload;

    float radAngle = _angle * DEG_TO_RAD;
    Vector2 vel = { 100, 0 };
    vector_rotate(&vel, radAngle, &vel);
    vector_add(&_v, &vel, &vel);

    Vector2 pos = { _boundingRadius, 0 };
    vector_rotate(&pos, radAngle, &pos);
    vector_add(&_x, &pos, &pos);

    [[_map gameController] addBullet:[EnemyBullet bulletInMap:_map
						  withPosition:&pos
						  velocity:&vel
						  orientation:_angle]];
}

- (void)run:(float)deltaTime
{
    _timer -= deltaTime;
    _reloadTimer -= deltaTime;
    if (_timer < 0) {
	[self brake];
	_state = random()%4;
	if (_state == 0) _timer = randomFloatBetween(0.5, 2);
	else if (_state == 1 || _state == 2) _timer = randomFloatBetween(1,2);
	else _timer = randomFloatBetween(2,4);
    }

    switch (_state) {
    case 0: /* do nothing */ break;
    case 1: [self rotateLeft:deltaTime]; [self accelerateForward]; break;
    case 2: [self rotateRight:deltaTime]; [self accelerateForward]; break;
    case 3: [self accelerateForward]; break;
    }

    if (random()%3 == 0) [self fireWeapon];

    _showExhaust = NO;

    [super run:deltaTime];

    if (_isDead) {
	[[_map gameController] addToScore:250];
	Jellybean *bean = [Jellybean randomBeanWithPosition:&_x inMap:_map];
	[[[_map gameController] unitList] addObject:bean];
    }
}

- (void)draw
{
    glPushMatrix();
    glTranslatef(_x.x, _x.y, 0);

    // Display the HP meter before rotating so that
    // it will always appear below the unit.
    if (_displayHPMeter) {
	[self drawHPMeter];
    }

    glRotatef(_angle, 0, 0, 1);

    glColor3ubv(_color);
    glBegin(GL_LINE_LOOP);
    glVertex2f( 15,  3);
    glVertex2f( 20,  2);
    glVertex2f( 20,  5);
    glVertex2f(  1, 15);
    glVertex2f(-12,  8);
    glVertex2f(  7,  5);
    glVertex2f(  7, -5);
    glVertex2f(-12, -8);
    glVertex2f(  1,-15);
    glVertex2f( 20, -5);
    glVertex2f( 20, -2);
    glVertex2f( 15, -3);
    glEnd();
    glColor3f(1,0,0);

    if (_shield) {
	glColor3f(1,0,0);
	glBegin(GL_LINE_LOOP);
	int i, n = 10;
	float r = _shieldRadius;
	float theta = 0;
	float dTheta = 2*M_PI/(float)n;
	for (i = 0; i < n; i++, theta += dTheta) {
	    glVertex2f(r*cos(theta), r*sin(theta));
	}
	glEnd();
    }

    glPopMatrix();
}

@end
