/* Jellybean Fugue 1.0
   Copyright (c) 2004 Phillip Nguyen

   Jellybean Fugue is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License or (at your option) any later version.  

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jellybean Fugue; see the file COPYING. If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info:
   nguyenp@eecs.tulane.edu
*/
#import <OpenGL/gl.h>
#import "EnemyBullet.h"
#import "ParticleEngine.h"
#import "Ship.h"
#import "GameController.h"


@implementation EnemyBullet

+ (Bullet *)bulletInMap:(GameMap *)map withPosition:(Vector2 *)x velocity:(Vector2 *)v orientation:(float)angle
{
    EnemyBullet *bullet = [[EnemyBullet alloc] initInMap:map
					       withPosition:x
					       velocity:v
					       orientation:angle];
    return [bullet autorelease];
}

- (BOOL)moveBy:(float)dx :(float)dy
{
    Vector2 delta = { dx, dy };
    _hitSomething = NO;

    // Check for collision with the wall we're fated to hit.
    if (_wallOfFate && check_moving_point_against_edge(&_x, &delta, _wallOfFate)) {
	_hitSomething = YES;
    }

    // Check for collision with the player's ship.
    Ship *ship = [[_map gameController] ship];
    if (check_moving_point_against_circle(&_x, &delta, [ship position], [ship boundingRadius])) {
	_hitSomething = YES;
	[ship takeDamage:1];
    }

    vector_add(&_x, &delta, &_x);

    return _hitSomething;
}

- (void)run:(float)deltaTime
{
    _angle += _omega * deltaTime;
    [super run:deltaTime];
}

- (void)explode
{
    Vector2 v[4] = { {2,2}, {-2,2}, {-2,-2}, {2,-2} };
    float radAngle = _angle * DEG_TO_RAD;
    int i;
    for (i = 0; i < 4; i++) {
	vector_rotate(&v[i], radAngle, &v[i]);
	vector_add(&v[i], &_x, &v[i]);
    }
    Edge e[4] = { {v[0],v[1]}, {v[1],v[2]}, {v[2],v[3]}, {v[3],v[0]} };
    float theta[4] = {90, 180, 270, 0};
    for (i = 0; i < 4; i++) {
	Vector2 vel = {10, 0};
	vector_rotate(&vel, theta[i]*DEG_TO_RAD + radAngle, &vel);
	[[ParticleEngine sharedParticleEngine] addEdge:&e[i] 
					       withVelocity:&vel
					       color:0x3f:0x7f:0xff
					       timer:0.6
					       fade:YES];
    }
}

- (void)draw
{
    glPushMatrix();
    glTranslatef(_x.x, _x.y, 0);
    glRotatef(_angle, 0, 0, 1);
    
    glColor3ub(0x3f, 0x7f, 0xff);
    glBegin(GL_LINE_LOOP);
    glVertex2f( 2, 2);
    glVertex2f(-2, 2);
    glVertex2f(-2,-2);
    glVertex2f( 2,-2);
    glEnd();

    glPopMatrix();
}
@end
