//
//  ARegistrationController.h
//  Frenzic
//
//  Created by Wolfgang Ante on 27.10.06.
//  Copyright 2006 ARTIS Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "ALeblonController.h"

#define	PRODUCT		"FR"

char *CreateMultiuserCodeVar (const char *name, const char *product, int users, char variation);
char *CreateMultiuserCode (const char *name, const char *product, int users);
int HowManyUsers (const char *code);
int IsMultiuserCodeValid (const char *name, const char *product, const char *code);
int IsRegistered (void);
BOOL MayPlay (void);

@interface ARegistrationController : NSObject
{
	NSImage		*accepted;
	NSImage		*locked;
	
	IBOutlet NSWindow		*registrationWindow;
	
	IBOutlet NSTextField	*nameField;
	IBOutlet NSTextField	*serialField;
	
	IBOutlet NSTextField	*loginField;
	IBOutlet NSTextField	*passwordField;
	
	IBOutlet NSImageView	*registerFeedback;
	IBOutlet NSImageView	*loginFeedback;
	
	IBOutlet NSButton				*loginButton;
	IBOutlet NSProgressIndicator	*loginSpinner;
}

- (IBAction)openRegistrationWindow:(id)sender;
- (IBAction)openRegistrationWebsite:(id)sender;

- (IBAction)updateRegistrationFeedback:(id)sender;
- (IBAction)updateLoginFeedback:(id)sender;

- (IBAction)checkRegistration:(id)sender;
- (IBAction)checkLogin:(id)sender;

- (NSString *)trim:(NSString *)string;

@end
