function MoveMainMenuPanels(where, reportArrivalTo, arrivalMessage)
	SendMessage("Top left ball mover", "report arrival to null")
	SendMessage("Top left ball mover", "set arrival message null")
	SendMessage("Top left ball mover", "move to "..where)
	SendMessage("Top right ball mover", "report arrival to null")
	SendMessage("Top right ball mover", "set arrival message null")
	SendMessage("Top right ball mover", "move to "..where)
	SendMessage("Main menu blue panel mover", "report arrival to null")
	SendMessage("Main menu blue panel mover", "set arrival message null")
	SendMessage("Main menu blue panel mover", "move to "..where)
	SendMessage("Main menu bottom panel mover", "report arrival to "..reportArrivalTo)
	SendMessage("Main menu bottom panel mover", "set arrival message "..arrivalMessage)
	SendMessage("Main menu bottom panel mover", "move to "..where)
end

function MainMenuFunc(message)
	if message == "Create main menu" then
		SendMessage("Screen", "template MainMenuTemplate")
		SendMessage("Screen", "create top instance")
		SendMessage("Current tank content", "template MainMenuCurrentTankSwitchTemplate")
		SendMessage("Current tank content", "create top instance")
	elseif message == "Enter main menu" then
		SendMessage("lua:MainMenuFunc", "Create main menu")
		MoveMainMenuPanels("in", "null", "null")
		do
			local change = false
			for tankId = 1, 2 do
				local lastOpen = PermanentStorage.GetLocalStringOrDef(tankId.." Last main menu cup", "None") ~= "None"
				local newOpen = PermanentStorage.GetLocalStringOrDef(tankId.." Cup", "None") ~= "None"
				if newOpen and not lastOpen then
					change = true
				else
					assert(newOpen == lastOpen)
				end
				PermanentStorage.SetLocalString(tankId.." Last main menu cup", PermanentStorage.GetLocalString(tankId.." Cup"))
			end
			if change then
				SendMessage("New background holder", "change alpha to 1.0")
			end
		end
	elseif message == "Main menu exit button pressed" then
		SendMessage("New background holder", "change alpha to 0.0")
		local isScreensaverEnabled = IsScreensaverEnabled()
		oldScreensaverEnabled = isScreensaverEnabled
		PermanentStorage.SetGlobalBool("isScreensaverEnabled", isScreensaverEnabled)
		if isScreensaverEnabled then
			SendMessage("Main menu modal dialog", "instantiate NoCheckboxExitConfirmationTemplate")
		else
			SendMessage("Main menu modal dialog", "instantiate CheckboxExitConfirmationTemplate")
		end
		SendMessage("Exit panel mover", "report arrival to null")
		SendMessage("Exit panel mover", "set arrival message null")
		SendMessage("Exit panel mover", "move to in")
	elseif message == "Exit confirmation dialog yes pressed" then
		local isScreensaverEnabled = PermanentStorage.GetGlobalBool("isScreensaverEnabled")
		if not oldScreensaverEnabled and isScreensaverEnabled then
			InstallScreensaver()
		end
		oldScreensaverEnabled = nil
		CloseApplication()
	elseif message == "Exit confirmation dialog no pressed" then
		local isScreensaverEnabled = PermanentStorage.GetGlobalBool("isScreensaverEnabled")
		if not oldScreensaverEnabled and isScreensaverEnabled then
			InstallScreensaver()
		end
		SendMessage("Main menu modal dialog", "hide")
		SendMessage("Exit panel mover", "report arrival to null")
		SendMessage("Exit panel mover", "set arrival message null")
		SendMessage("Exit panel mover", "move to out")
	elseif message == "Change player link pressed" then
		SendMessage("New background holder", "change alpha to 0.0")
		SendMessage("Main menu modal dialog", "instantiate PlayersDialogTemplate")
		SendMessage("Players dispatcher", "report finish to lua:MainMenuFunc")
		SendMessage("Players dispatcher", "set finish message Player change finished")
		SendMessage("Players dispatcher", "Show dialog")
	elseif message == "Player change finished" then
		SendMessage("Main menu modal dialog", "hide")
	elseif message == "Main menu screensaver button pressed" then
		SendMessage("New background holder", "change alpha to 0.0")
		local isScreensaverEnabled = IsScreensaverEnabled()
		oldScreensaverEnabled = isScreensaverEnabled
		PermanentStorage.SetGlobalBool("isScreensaverEnabled", isScreensaverEnabled)
		SendMessage("Main menu modal dialog", "instantiate ScreensaverOptionsDialogTemplate")
		SendMessage("Screensaver Options mover", "report arrival to null")
		SendMessage("Screensaver Options mover", "set arrival message null")
		SendMessage("Screensaver Options mover", "move to in")
	elseif message == "Screensaver options tank 1 pressed" then
		PermanentStorage.SetLocalString("Screensaver Tank", "1")
	elseif message == "Screensaver options tank 2 pressed" then
		PermanentStorage.SetLocalString("Screensaver Tank", "2")
	elseif message == "Screensaver options tank 3 pressed" then
		PermanentStorage.SetLocalString("Screensaver Tank", "3")
	elseif message == "Screensaver options preview button pressed" then
		SendMessage("Screen", "template DarkeningTemplate")
		SendMessage("Screen", "defineText [receiver] post:lua:MainMenuFunc")
		SendMessage("Screen", "defineText [message] Main menu darkened for screensaver preview")
		SendMessage("Screen", "create top instance")
	elseif message == "Main menu darkened for screensaver preview" then
		SendMessage("Current tank content", "clear children list")
		SendMessage("Screen", "template TankOnlyTemplate")
		SendMessage("Screen", "defineText [variable] Screensaver Tank")
		SendMessage("Screen", "defineText [exitMessageReceiver] post:lua:MainMenuFunc")
		SendMessage("Screen", "defineText [exitMessage] Screensaver preview done")
		SendMessage("Screen", "create top instance")
		SendMessage("Screen", "template BrighteningTemplate")
		SendMessage("Screen", "create top instance")
	elseif message == "Screensaver preview done" then
		SendMessage("Screen", "template DarkeningTemplate")
		SendMessage("Screen", "defineText [receiver] post:lua:MainMenuFunc")
		SendMessage("Screen", "defineText [message] Screensaver preview darkened")
		SendMessage("Screen", "create top instance")
	elseif message == "Screensaver preview darkened" then
		SendMessage("Screen", "erase top child") -- DarkeningTemplate
		SendMessage("Screen", "erase top child") -- BrighteningTemplate
		SendMessage("Screen", "erase top child") -- TankOnlyTemplate
		SendMessage("Screen", "erase top child") -- DarkeningTemplate
		SendMessage("Screen", "template BrighteningTemplate")
		SendMessage("Screen", "create top instance")
		SendMessage("Current tank content", "template MainMenuCurrentTankSwitchTemplate")
		SendMessage("Current tank content", "create top instance")
	elseif message == "Screensaver options ok button pressed" then
		local isScreensaverEnabled = PermanentStorage.GetGlobalBool("isScreensaverEnabled")
		PermanentStorage.UndefGlobalName("isScreensaverEnabled")
		if not oldScreensaverEnabled and isScreensaverEnabled then
			InstallScreensaver()
		elseif oldScreensaverEnabled and not isScreensaverEnabled then
			UninstallScreensaver()
		else
			assert(oldScreensaverEnabled == isScreensaverEnabled)
		end
		oldScreensaverEnabled = nil
		SendMessage("Main menu modal dialog", "hide")
		SendMessage("Screensaver Options mover", "report arrival to null")
		SendMessage("Screensaver Options mover", "set arrival message null")
		SendMessage("Screensaver Options mover", "move to out")
	elseif message == "Screensaver options cancel button pressed" then
		PermanentStorage.UndefGlobalName("isScreensaverEnabled")
		oldScreensaverEnabled = nil
		SendMessage("Main menu modal dialog", "hide")
		SendMessage("Screensaver Options mover", "report arrival to null")
		SendMessage("Screensaver Options mover", "set arrival message null")
		SendMessage("Screensaver Options mover", "move to out")
	elseif message == "Main menu options button pressed" then
		SendMessage("New background holder", "change alpha to 0.0")
		SendMessage("Main menu modal dialog", "instantiate MainMenuOptionsDialogTemplate")
		SendMessage("Options dispatcher", "report finish to lua:MainMenuFunc")
		SendMessage("Options dispatcher", "set finish message Main menu options dialog finished")
		SendMessage("Options dispatcher", "Show dialog")
	elseif message == "Main menu options credits button pressed" then
		SendMessage("Screen", "template ZGlassTemplate")
		SendMessage("Screen", "create top instance")
		SendMessage("Main menu modal dialog alpha changer", "change alpha to 0.0")
		SendMessage("Game logo alpha changer", "change alpha to 0.0")
		MoveMainMenuPanels("out", "post:lua:MainMenuFunc", "Main menu panel out for credits")
	elseif message == "Main menu panel out for credits" then
		SendMessage("Screen", "erase top child")
			-- ZGlass
		SendMessage("Screen", "template MainMenuCreditsZGlassTemplate")
		SendMessage("Screen", "create top instance")
		SendMessage("Screen", "template CreditsTemplate")
		SendMessage("Screen", "create top instance")
	elseif message == "Main menu credits click" then
		SendMessage("Screen", "erase top child")
			-- Credits
		SendMessage("Screen", "erase top child")
			-- ZGlass
		SendMessage("Main menu modal dialog alpha changer", "change alpha to 1.0")
		SendMessage("Game logo alpha changer", "change alpha to 1.0")
		MoveMainMenuPanels("in", "null", "null")
	elseif message == "Main menu options dialog finished" then
		SendMessage("Main menu modal dialog", "hide")
	elseif message == "Main menu start button pressed" then
		SendMessage("New background holder", "change alpha to 0.0")
		SendMessage("Screen", "template ZGlassTemplate")
		SendMessage("Screen", "create top instance")
			--  
		MoveMainMenuPanels("out", "post:lua:MainMenuFunc", "Main menu panel out for main screen")
		SendMessage("Game logo alpha changer", "change alpha to 0.0")
	elseif message == "Main menu panel out for main screen" then
		SendMessage("Screen", "clear children list")
		SendMessage("lua:MainScreenFunc", "Enter main screen")

		SendMessage("lua:TutorialFunc", "Main menu panel out for main screen")

		SendMessage("lua:BetaFunc", "Main menu to main screen")
	else
		assert(false, "Unknown message "..message)
	end
end