//
//  NSAppleScript+ASWHandlerCalls.h
//  ASWFoundation
//
//  Created by Dominic Feira on 11/10/09.
//  Copyright 2009 Ambrosia Software, Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface NSAppleEventDescriptor(ASWEventDescriptor)
/*! Create an event descriptor with the provide object.
 \param object The cocoa object to convert into an event descriptor.
 \result nil if conversion unsuccessful.
 \discussion Can convert NSNumber, NSString, NSArray.
 */
+ (NSAppleEventDescriptor*) appleEventDescriptorWithObject: (id) object;

/*! Convert a NSAppleEventDesctriptor to a cocoa object.
 \param object The NSAppleEventDescriptor object to convert into an object.
 \result nil if conversion unsuccessful.
 \discussion Can convert numbers, booleans, strings, and lists to NSNumber, NSNumber, NSString, NSArray.
 */
+ (id) objectWithAppleEventDescriptor: (NSAppleEventDescriptor*) descriptor;
@end

@interface NSAppleScript(ASWHandlerCalls)

/*! Execute the script handler with the given name. Use this method if you want to manipulat NSAppleEventDescriptors yourself.
 \param parameterList NSAppleEventDescriptor that contains the parameters list
 \param errorInfo On return contains any error information.  optionally pass nil.
 \param result Raw NSAppleEventDescriptors containing the result of the call.
 */
- (NSAppleEventDescriptor*) callScript:(NSString *)handlerName 
				 withArrayOfParameters:(NSAppleEventDescriptor*) parameterList 
								 error: (NSDictionary**) errorInfo;

/*! Execute the script handler with the given name. This method coerces types for you. 
 Accepts NSNumber, NSString, NSArray, or NSAppleEventDescriptor.  
 Because numbers and bools are different in applescript some care must be taken to differentiate the two.
 If you want to pass a boolean, you should create it with [NSAppleEventDescriptor descriptorWithBoolean:]
 \param parameterList NSAppleEventDescriptor that contains the parameters list
 \param errorInfo On return contains any error information.  optionally pass nil.
 \result Result as cocoa objects.  NSNumber, NSString, NSArrays are supported.  Any other type will cause an exception.
 */
- (id) callHandler: (NSString *)handlerName 
			 error: (NSDictionary**) errorInfo 
	 withArguments: (NSArray*) arguments;


/*! Same as callhandler:error:withArguments: except parameters are null terminated list instead of an array. */
- (id) callHandler: (NSString *)handlerName 
			 error: (NSDictionary**) errorInfo 
	withParameters: (id) firstParameter, ... ;

@end
