//
//  ASWSerializedPlist.h
//  ASWFoundation
//
//  Created by Dan Mendoza on 6/28/11.
//  Copyright 2011 Ambrosia Software, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ASWPlistable.h"

/*! \file ASWPlistHash.h */

extern NSString* ASWSerializedPlistException;

@interface NSObject(ASWSerializedPlist)

/*! 
 \brief Recursive function to serialize a plist into a flat data object. 
 Guarantees that dictionaries are ordered by key. 
 
 WARNING: This implementation can be orders of magnitude slower than
 its counterpart, NSPropertyListSerialization for all but the smallest
 plist hierarchies.
 
 \return a binary serialization if object is a plist, otherwise nil
 */
- (NSData *)serializedPlist;

@end
