/*
 *  ASWNotificationCenter.h
 *  WireTapPro2
 *
 *  Created by Dominic Feira on 12/21/05.
 *  Copyright 2005 __MyCompanyName__. All rights reserved.
 *
 */

/*! \file ASWNotificationCenter.h */

@interface ASWNotificationCenter : NSNotificationCenter

@end

/*! \brief  An NSNotificationCenter category that adds methods for posting notifications on the main thread. */
@interface NSNotificationCenter(ASWNotificationCenterCategory)

/*! \brief Posts a notification on the main thread.
	\param notificationName The notification name to post. */
- (void)postNotificationNameOnMainThread:(NSString *)notificationName;

/*! \brief Posts a notification on the main thread.
	\param notificationName The notification to post.
	\param anObject The object to associate the notification with. */
- (void)postNotificationNameOnMainThread:(NSString *)notificationName object:(id)anObject;

/*! \brief Posts a notification on the main thread.
	\param notificationName The notification to post.
	\param anObject The object to associate the notificatoin with.
	\param userInfo The userInfo dictionary to attach to the notification.
*/
- (void)postNotificationNameOnMainThread:(NSString *)notificationName object:(id)anObject userInfo:(NSDictionary *)userInfo;

/*! \brief Posts a notification on the main thread.
	\param notification The notification to post. */
- (void) postNotificationOnMainThread: (NSNotification*) notification;
@end
