/*
 *  ASWMathMacros.h
 *  ASWFoundation
 *
 *  Created by Rudy Richter on 8/3/09.
 *  Copyright 2009 Ambrosia Software, Inc.. All rights reserved.
 *
 */

//#import <tgmath.h>

#ifndef ASWMATHMACROS
#define ASWMATHMACROS 1

#define ASW_M_PI (CGFloat)M_PI
#define ASW_M_PI_2 (CGFloat)M_PI_2

#ifdef __LP64__
#define ASWSin(x) sinl(x)
#define ASWCos(x) cosl(x)
#define ASWTan(x) tanl(x)
#define ASWASin(x) asinl(x)
#define ASWACos(x) acosl(x)
#define ASWATan(x) atanl(x)
#define ASWATan2(x, y) atan2l(x, y)
#define ASWHypot(x, y) hypotl(x, y)
#define ASWSqrt(x) sqrtl(x)
#define ASWFAbs(x) fabsl(x)
#define ASWCbrt(x) cbrtl(x)
#define ASWCopysign(x, y) copysignl(x, y)
#define ASWCeil(x) ceill(x)
#define ASWFloor(x) floorl(x)
#define ASWLog(x) logl(x)
#define ASWFMod(x, y) fmodl(x, y)
#define ASWTrunc(x) truncl(x)
#define ASWLRound(x) lroundl(x)
#define ASWPow(x, y) powl(x, y)
#define ASWExp(x) expl(x)
#define ASWAbs(x) labs(x)
#define ASWRound(x) roundl(x)
#else
#define ASWSin(x) sinf(x)
#define ASWCos(x) cosf(x)
#define ASWTan(x) tanf(x)
#define ASWASin(x) asinf(x)
#define ASWACos(x) acosf(x)
#define ASWATan(x) atanf(x)
#define ASWATan2(x, y) atan2f(x, y)
#define ASWHypot(x, y) hypotf(x, y)
#define ASWSqrt(x) sqrtf(x)
#define ASWFAbs(x) fabsf(x)
#define ASWCbrt(x) cbrtf(x)
#define ASWCopysign(x, y) copysignf(x, y)
#define ASWCeil(x) ceilf(x)
#define ASWFloor(x) floorf(x)
#define ASWLog(x) logf(x)
#define ASWFMod(x, y) fmod(x, y)
#define ASWTrunc(x) trunc(x)
#define ASWLRound(x) lroundf(x)
#define ASWPow(x, y) powf(x, y)
#define ASWExp(x) exp(x)
#define ASWAbs(x) abs(x)
#define ASWRound(x) roundf(x)
#endif

#define ASWFloatEqualWithTolerance(l, r, t) ((fabs((double)l - (double)r)) <= (double)t)
#define ASWFloatEqual(l, r) ((l >= r) && (l <= r))

#endif
