//
//  ASWJobQueue.h
//  ASWFoundation
//
//  Created by dominic on 5/24/07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import "ASWJob.h"
@class ASWJobQueue;

@protocol ASWJobQueueDelegate
- (void) jobQueue: (ASWJobQueue*) queue didStartJob: (ASWJob*) job;

- (void) jobQueue: (ASWJobQueue*) queue didPauseJob: (ASWJob*) job;
- (void) jobQueue: (ASWJobQueue*) queue didResumeJob: (ASWJob*) job;

- (void) jobQueue: (ASWJobQueue*) queue didCancelJob: (ASWJob*) job;
- (void) jobQueue: (ASWJobQueue*) queue didCompleteJob: (ASWJob*) job;

@end



@interface ASWJobQueue : NSObject <NSLocking, ASWJobDelegate>
{
	NSRecursiveLock* mLock;
	NSMutableArray* mPendingJobs;
	NSMutableArray* mPausedJobs;
	NSMutableArray* mActiveJobs;
	
	NSUInteger mMaxConcurrentJobs;
	CGFloat mPriority;
	id <ASWJobQueueDelegate> mDelegate;
}
+ (NSUInteger) numCores;
- (id) init __attribute__((deprecated));
- (void) setMaxConcurrentJobs: (NSUInteger) max;
- (NSUInteger) maxConcurrentJobs;

- (NSUInteger) numberOfActiveJobs;
- (NSUInteger) numberOfPendingJobs;
- (NSUInteger) numberOfJobs;

- (void) setPriority: (CGFloat) priority;
- (CGFloat) priority;

- (void) startNextJobIfNeeded;
- (void) addJob: (ASWJob*) job;
- (void) cancelJob: (ASWJob*) job;
- (void) cancelAllJobs;

- (void) lock;
- (void) unlock;

- (void) setDelegate: (id <ASWJobQueueDelegate>) delegate;
- (id <ASWJobQueueDelegate>) delegate;

// do not change the jobs in any way shape or form!!!
- (NSArray*) activeJobs;
@end
