//
//  ASWJob.h
//  ASWFoundation
//
//  Created by dominic on 5/24/07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

typedef enum 
{
	kASWJobState_Waiting = 0,
	kASWJobState_InProgress,
	kASWJobState_Paused,
	kASWJobState_Completed,
	kASWJobState_Cancelled
} ASWJobState;

@class ASWJob;
@protocol ASWJobDelegate
- (void) jobDidStart: (ASWJob*) job;
- (void) jobDidPause: (ASWJob*) job;
- (void) jobDidResume: (ASWJob*) job;
- (void) jobDidComplete: (ASWJob*) job;
- (void) jobDidCancel: (ASWJob*) job;
- (void) jobStateDidChange: (ASWJob*)job;
@end

@interface ASWJob : NSObject <NSLocking> 
{
	NSLock* mLock;
	CGFloat mPriority;
	
	id <ASWJobDelegate> mDelegate;
	ASWJobState mCurrentState;
	
	NSError* mError;
}
- (id) init __attribute__((deprecated));
- (void) setError: (NSError*) error;
- (NSError*) error;

- (void) setPriority: (CGFloat) priority;
- (CGFloat) priority;

- (void) setDelegate: (id <ASWJobDelegate>) delegateIn;
- (id <ASWJobDelegate>) delegate;

- (void) lock;
- (void) unlock;

- (BOOL) start;
- (void) cancel;
- (void) pause;
- (void) resume;

- (void) jobDidCancel;
- (void) jobDidError: (NSError*) error;
- (void) jobDidComplete;

- (ASWJobState) currentState;

@end
