//
//  ASWFileRefEnumerator.h
//  ASWFoundation
//
//  Created by dominic on 9/21/07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "ASWFileRef.h"
/*! \brief Implements a NSEnumerator for file paths
 
	This is the fastest way to enumerate paths, especially if you might not enumerate all of them. */
@interface ASWFileRefEnumerator : NSEnumerator 
{
	// the fileRef that is being enumerated
	ASWFileRef* mFileRef;
	FSIterator iterator;
}

/*! \brief Init an enumerator for the given fileRef.  Must be a directory */
- (id) initWithFileRef: (ASWFileRef*) fileRef;

@end
