//
//  ASWFileIconTransformer.h
//  ASWFoundation
//
//  Created by Dominic Feira on 11/27/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

/*! \brief ASWFileIconTransformer transforms paths into icons
 
	Optionally it can cache icons with a specified cache size.
 */

@interface ASWFileIconTransformer : NSObject 
{
	NSUInteger mCacheSize;
	NSMutableDictionary* mIcons;
	NSMutableArray* mKeyAddOrder;
}
/*! \brief Set the maximum cache size */
- (void) setCacheSize: (NSUInteger) count;

/*! \brief Maximum cache size */
- (NSUInteger) cacheSize;

/*! \brief Tell the cache to flush old values 
 
	This is done automatically, though you can force it by calling this method.
 */
- (void) flushCache;
@end
