//
//  ASWError.h
//  ASWFoundation
//
//  Created by Matt Slot on 2/5/10.
//  Copyright 2010 Ambrosia Software, Inc.. All rights reserved.
//

@interface NSError(ASWError)

/*! Convenience factory method for generating errors with descriptive messages.
	\param code The OSStatus error code.
	\param description The primary alert text, displayed in bold.
	\param reason Longer message text, explains the reason for the error.
	\result An autoreleased NSError object. */
+ (id)errorWithOSStatus:(OSStatus)code description:(NSString *)description reason:(NSString *)reason;

@end
