//
//  ASWDurationFormatter.h
//  WireTapPro2
//
//  Created by Dominic Feira on 5/24/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

/*! \brief Formats a duration from a number */
@interface ASWDurationFormatter : NSFormatter 
{
	BOOL mAllowsOneZero;
	BOOL mAlwaysShowHours;
	BOOL mAlwaysShowMinutes;
	BOOL mIncludeMilliseconds;
	BOOL mDisplaysZero;
	BOOL mShowsLastUnitLabel;
	NSString* mSeparator;
}

/*! \brief Sets wether or not a unit label is shown for the rightmost unit */
- (void) setShowsLastUnitLabel: (BOOL) show;

/*! \brief YES if a unit label is shown for the rightmost unit */
- (BOOL) showsLastUnitLabel;

/*! \brief Set the separator string.  Default is :  example:  10:15:09 */
- (void) setSeparator: (NSString*) string;

/*! \brief The separator string */
- (NSString*) separator;

/*! \brief Sets wether or not a unit component may be represented by only on zero. 
	
	Example:  0:0:10s
 */
- (void) setAllowsOneZero: (BOOL) allow;

/*! \brief Wether or not a unit component may be represented by only one zero.*/
- (BOOL) allowsOneZero;

/*! \brief Sets wether or not the hours component is always shown 
	
	Example:  yes, 0:10:05s  no, 10:05s
 */
- (void) setAlwaysShowHours: (BOOL) show;

/*! \brief Wether or not the hours component is always shown */
- (BOOL) alwaysShowHours;

/*! \brief Sets wether or not the minutes component is always shown 

 	Example:  yes, 0:05s  no, 00:05s
 */
- (void) setAlwaysShowMinutes: (BOOL) show;

/*! \brief Wether or not the the minutes component is always shown */
- (BOOL) alwaysShowMinutes;

/*! \brief Set wether or not the milliseconds component is always shown */
- (void) setIncludeMilliseconds: (BOOL) include;

/*! \brief Wether or not the milliseconds component is always shown */
- (BOOL) includeMilliseconds;

/*! \brief Set wether or not the value zero is translated to an empty string or 
 
	Example:  yes, 00:00:00  no, "" */
- (void) setDisplaysZero: (BOOL) display;

/*! \brief Wether or not zero formats as an empty string */
- (BOOL) displaysZero;
@end
