//
//  ASWDisabledColorTransformer.h
//  WireTapPro2
//
//  Created by Dominic Feira on 12/20/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

/*! \file ASWDisabledColorTransformer.h */

/*! A NSTransformer that transforms an NSNumber (boolean) to either the disabled text color or black. */
@interface ASWDisabledColorTransformer: NSValueTransformer 
{
#if defined(__IPHONE_4_0) &&  __IPHONE_4_0 <= __IPHONE_OS_VERSION_MIN_REQUIRED
	UIColor* mEnabledColor;
	UIColor* mDisabledColor;
#elif defined(ASW_NOT_IPHONE) && ASW_NOT_IPHONE
	NSColor* mEnabledColor;
	NSColor* mDisabledColor;
#endif
}
/*! \brief Get the default disabled color transformer */
+ (id) disabledColorTransformer;

/*! \brief Get the default inverse disabled color transformer */
+ (id) inverseDisabledColorTransformer;
#if defined(__IPHONE_3_0) &&  __IPHONE_3_0 <= __IPHONE_OS_VERSION_MAX_ALLOWED

/*! \brief Init a transformer with specified colors */
- (id) initWithDisabledColor: (UIColor*) disabledColor enabledColor: (UIColor*) enabledColor;
#elif defined(ASW_NOT_IPHONE) && ASW_NOT_IPHONE
/*! \brief Init a transformer with specified colors */
- (id) initWithDisabledColor: (NSColor*) disabledColor enabledColor: (NSColor*) enabledColor;
#endif
@end
