//
//  ASWDictionaryTransformer.h
//  Dragster
//
//  Created by Michael Blaguszewski on 2/28/06.
//  Copyright 2006 Ambrosia Software. All rights reserved.
//

/*! \file ASWDictionaryTransformer.h */

/*! \brief A general, non-reversable transformer that uses a dictionary lookup for its mapping function */
@interface ASWDictionaryTransformer : NSValueTransformer
{
	NSDictionary *mDictionary;
	id mDefaultValue;
}
/*! Returns NSObject, since each instance may be different. This doesn't seem to make any practical difference. */
+ (Class)transformedValueClass;
/*! \brief Create a new transformer the mapping in dictionary */
- (id)initWithDictionary:(NSDictionary *)dictionary;
/*! \brief Transformed value to use if dictionary lookup fails.
	
	If not explicity set, the default value is nil. */
- (void)setDefaultValue:(id)defaultValue;
@end
