//
//  ASWDictionary.h
//  WireTapPro2
//
//  Created by Dominic Feira on 5/11/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

/*! \file ASWDictionary.h */

/*! \brief NSDictionary category */
@interface NSDictionary (ASWDictionary_Category)
/*! \brief Creates a dictionary with NSNull values */
+ (id)dictionaryWithKeys:(NSArray *)keys;

#if defined(__IPHONE_3_0) &&  __IPHONE_3_0 <= __IPHONE_OS_VERSION_MAX_ALLOWED
#elif defined(ASW_NOT_IPHONE) && ASW_NOT_IPHONE
/*! \brief Decode an object from the dictionary for the given key */
- (id) decodedObjectForKey: (NSString*) aKey;

/*! \brief Get a color value for the given key. */
- (NSColor*) colorForKey: (NSString*) key;
#endif

/*! \brief Write the dictionary to URL
	\param atomically YES if the write should be atomic
	\param error Optional errorOut */
- (BOOL)writeToURL:(NSURL *)url atomically:(BOOL)atomically error:(NSError**)errorOut;

/*! \brief Convenience method for getting a bool value
	\return Value stored in the dictionary.  Returns NO if the value doesn't exist */
- (BOOL) boolForKey: (NSString*) key;

/*! \brief Convenience method for getting a double value
 \return Value stored in the dictionary.  Returns 0.0 if the value doesn't exist */
- (double) doubleForKey: (NSString*) key;

/*! \brief Convenience method for getting a long long value
 \return Value stored in the dictionary.  Returns 0 if the value doesn't exist */
- (long long) integerForKey: (NSString*) key;

/*! \brief Convenience method for getting a unsigned long long value
 \return Value stored in the dictionary.  Returns 0 if the value doesn't exist */
- (unsigned long long) unsignedIntegerForKey: (NSString*) key;


@end

/*! \brief NSMutableDictionary category */
@interface NSMutableDictionary (ASWDictionary_Category)

/*! \brief Convenience method for setting a bool value */
- (void) setBool: (BOOL) value forKey: (NSString*) key;

/*! \brief Convenience method for setting a double  value */
- (void) setDouble: (double) value forKey: (NSString*) key;

/*! \brief Convenience method for setting a long long value */
- (void) setInteger: (long long) value forKey: (NSString*) key;

/*! \brief Convenience method for setting an unsigned long long value */
- (void) setUnsignedInteger: (unsigned long long) value forKey: (NSString*) key;

#if defined(__IPHONE_3_0) &&  __IPHONE_3_0 <= __IPHONE_OS_VERSION_MAX_ALLOWED
#elif defined(ASW_NOT_IPHONE) && ASW_NOT_IPHONE
/*! \brief Convenience method for setting an color value 
	
	The color is stored as an encoded object.
 */
- (void) setColor:(NSColor *)aColor forKey:(NSString *)aKey;

/*! \brief Set an object for a key.  The value is stored as an encoded object */
- (void) setEncodedObject: (id<NSCoding>) object forKey: (NSString*)aKey;
#endif


/*! \brief Add values for the keys that are not already in this dictionary */
- (void) addUniqueEntriesFromDictionary:(NSDictionary*)otherDictionary;
@end
