//
//  ASWData+Handle.h
//  ASWFoundation
//
//  Created by Jon Gary on 6/21/11.
//  Copyright 2011 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*! 
 \brief Additions for dealing with classic toolbox handles. 
 */
@interface NSData (ASWData_Handle)

/*!
 \brief Return a new NSData with a copy of the contents of theHandle.
 \param theHandle A toolbox handle, cannot be nil.
 \return An autoreleased NSData.
 */
+ (NSData*) dataWithContentsOfHandle:(Handle)theHandle;

/*!
 \brief Return a new handle with a copy of the contents of the receiver.
 \return A newly allocated handle that the caller must deallocate with DisposeHandle, or nil if an error occurs.
 */
- (Handle) newHandleWithContents;

@end
