/*
 *  ASWCocoaMacros.h
 *  ASWFoundation
 *
 *  Created by Dominic Feira on 2/14/07.
 *  Copyright 2007 Ambrosia Software, Inc. All rights reserved.
 *
 */

#if !defined(CGFLOAT_DEFINED)
#define CGFLOAT_DEFINED 1
#if defined(__LP64__) && __LP64__
typedef double CGFloat;
#define CGFLOAT_MIN DBL_MIN
#define CGFLOAT_MAX DBL_MAX
#define CGFLOAT_IS_DOUBLE 1
#else	/* !defined(__LP64__) || !__LP64__ */
typedef float CGFloat;
#define CGFLOAT_MIN FLT_MIN
#define CGFLOAT_MAX FLT_MAX
#define CGFLOAT_IS_DOUBLE 0
#endif	/* !defined(__LP64__) || !__LP64__ */
#endif

#if !defined(NSINTEGER_DEFINED)
#define NSINTEGER_DEFINED 1

#if __LP64__ || NS_BUILD_32_LIKE_64
typedef long NSInteger;
typedef unsigned long NSUInteger;
#else
typedef int NSInteger;
typedef unsigned int NSUInteger;
#endif

#define NSIntegerMax    LONG_MAX
#define NSIntegerMin    LONG_MIN
#define NSUIntegerMax   ULONG_MAX
#endif

#define ASSIGN(_lhs, _rhs) do{ id _tempRHS = [_rhs retain]; [_lhs release]; _lhs = _tempRHS; }while(0)
#define ASSIGN_COPY(_lhs, _rhs) do{ id _tempRHS = [_rhs copy]; [_lhs release]; _lhs = _tempRHS; }while(0)
#define ASSIGN_MCOPY(_lhs, _rhs) do{ id _tempRHS = [_rhs mutableCopy]; [_lhs release]; _lhs = _tempRHS; }while(0)
#define RETURN_COPY(_lhs)  return [[_lhs copy] autorelease]
#define RETURN_MCOPY(_lhs) return [[_lhs mutableCopy] autorelease]
#define RETURN_TSAFE(_lhs) return [[_lhs retain] autorelease]
#define RELEASE(_lhs) do{ [_lhs release]; _lhs = nil;	}while(0)

#define CFRELEASE(_lhs) do{ if(_lhs){ CFRelease(_lhs); _lhs = NULL; } }while(0)

// For assigning between CGRect and NSRect, which have the same member variables, but not necessarily
// the same layout in memory.
// It is very clear that Apple is purposely aligning CGRect and NSRect so their
// representation in memory is identical.
#define ASSIGN_RECT(_lhs, _rhs) do \
	{ \
		__typeof__(_rhs) rhs = (_rhs); \
		_lhs.origin.x = rhs.origin.x; \
		_lhs.origin.y = rhs.origin.y; \
		_lhs.size.width = rhs.size.width; \
		_lhs.size.height = rhs.size.height; \
	} \
	while(0)

// Deprecated: Cocoa's built-in MIN() and MAX() are safer
#define ASW_MAX(_lhs, _rhs) ((_lhs > _rhs) ? _lhs : _rhs)
#define ASW_MIN(_lhs, _rhs) ((_lhs < _rhs) ? _lhs : _rhs)
