//
//  ASWBundle.h
//  ASWFoundation
//
//  Created by rudy on 4/16/08.
//  Copyright 2008 Ambrosia Software, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

/*! \file ASWBundle.h */

/*! \brief A NSBundle category that adds useful methods. */

@interface NSBundle (PathAdditions)

/*! \brief returns the bundle's path to the Mac App Store (MAS) receipt
 \return An NSString. */
- (NSString*)receiptPath;

/*! \brief returns the bundle's path to the Helpers directory
	\return An NSString. */
- (NSString*)helperPath;

/*! \brief returns the path to the specified executable file or
	app bundle within the Helpers directory.
	\discussion When searching for an app bundle, the .app extension
	can be omitted. */
- (NSString *)pathForHelper:(NSString *)helperName;
@end
