/*
 *  ASWArray.h
 *  WireTapPro2
 *
 *  Created by Dominic Feira on 12/21/05.
 *  Copyright 2005 __MyCompanyName__. All rights reserved.
 *
 */

extern NSString* ASWArrayNonIdReturnType;

/*! \file ASWArray.h */

/*! \brief An NSArray category that adds useful methods. */
@interface NSArray(ASWArray)
/*! \brief Gets the first object of a NSArray using Lisp-style.
	\return The first object of the receiver.  Nil if the receiver is empty. */
- (id) car;

/*! \brief Get the contents of the receiver, except the first element.
	\return An NSArray.  Nil if the receiver has a count less than 2. */
- (id) cdr;

/*! \brief Returns an array containing the objects of the receiver, but in reverse order.
	\return An NSArray. */
- (NSArray*) reverseArray;

/*! \brief Performs the performSelector:withObject: on all objects in self.
	\param selector The selector to perform.
	\param object The argument.
	\return An NSArray containing the results of each performSelector:withObject: NSNull is used as a placeholder for nil results. */
- (NSArray*) makeObjectsPerformSelectorWithResults: (SEL) selector withObject: (id) object;

/*! \brief Performs the performSelector:withObject: on all objects in self.
	\param selector The selector to perform.
	\param objects The argument.
	\return An NSArray containing the results of each performSelector:withObject: NSNull is used as a placeholder for nil results. */
- (NSArray*) makeObjectsPerformSelectorWithResults: (SEL) selector withObjects: (NSArray*) objects;

/*! \brief Performs the performSelector:withObject: on all objects in self.
	\param selector The selector to perform.
	\return An NSArray containing the results of each performSelector:withObject: NSNull is used as a placeholder for nil results. */
- (NSArray*) makeObjectsPerformSelectorWithResults: (SEL) selector;

/*! \brief Analogous to -[NSString hasPrefix:] */
- (BOOL)hasPrefix:(NSArray *)array;

/*! \brief creates a NSArray that contains only the indexes supplied
	\param indexes the indexes we want in the subset. */
- (NSArray*)subsetOfArrayAtIndexes:(NSIndexSet*)indexes;

/*! \brief Wrapper for CFArrayBSearchValues(), search the array for an object with the same value.
	\param desiredValue Sample object to be passed to comparator, against which the search will be performed.
	\param comparator Standard comparator function used for sorting NSArrays.
	\param context Opaque data pointer to pass to comparator function.
	\return Index of the element that matched, or if no exact match, then the index of the element with the next highest value.
		If all of the elements in the array fall before the desired value, the search result will be [NSArray count]. */
- (NSInteger)bsearch:(id)desiredValue comparatorFunction:(NSInteger (*)(id, id, void *))comparator context:(void *)context;

/*! \brief Wrapper for CFArrayBSearchValues(), search the array for an object with the same value.

	Note the following caveat: http://borkware.com/quickies/single?id=372
	If you use CFArrayBSearchValues, be sure to sort with CFArraySortValues rather than using the Cocoa sorting 
	routines (or at least the comparison) - they treat diacritic marks differently, leading to strange errors.

	\param desiredValue Sample object to be passed to comparator, against which the search will be performed.
	\param comparator Selector to invoke for comparison, having signature -(NSInteger)compare:(id)obj
	\return Index of the element that matched, or if no exact match, then the index of the element with the next highest value.
		If all of the elements in the array fall before the desired value, the search result will be [NSArray count]. */
- (NSInteger)bsearch:(id)desiredValue selector:(SEL)comparator;

/*! \brief returns an NSMutableArray that contains copies of the objects in this array.
	
	NOTE: It does not recurse.  It only copies its contents.  It does not copy the content's contents. */
- (NSMutableArray*) mutableDeepCopy;


/*! \brief returns an NSArray that contains copies of the objects in this array.
	
	NOTE: It does not recurse.  It only copies its contents.  It does not copy the content's contents. */
- (NSArray*) deepCopy;

/*	\brief returns an NSArray that contains members that match the provided comparator */
- (NSArray*) subarrayMatchingSelector: (SEL) selector withObject: (id) rhs;
@end


/*! \brief An NSMutableArray category that adds useful methods. */
@interface NSMutableArray(ASWArray)

/*! \brief Removes object from beginning of array, returning it.  For using NSMutableArray as a queue. */
- (id)dequeueObjectFromFront;
// could possibly have a matching enqueueObjectAtEnd:, or other front/end combinations

/*! \brief Reverses the order of objects in the receiver. */
- (void) reverse;

/*! \brief insert an array of objects at a particular starting point.
	\param objects the objects to insert into the array
	\param index the starting index that the objects should be inserted at */
- (void) insertObjects:(NSArray*)objects atIndex:(unsigned)index;

/*!	\brief moves a set of indexes to a particular location
	\param indexes the starting index that the objects should be inserted at
	\param destination the starting index to move to */
- (void) moveObjectsAtIndexes:(NSIndexSet*)indexes toIndex:(unsigned)destination;

/*! \brief Moves an object at a given index to another location.
	\param index the object that should be moved
	\param destination the index the object should be moved to
*/
- (void) moveObjectAtIndex:(unsigned)index toIndex:(unsigned)destination;

/*! \brief Replace an object identical to replace with the object.
	
	If replace is not in the array this is a nop.  If object is nil, then replace is simply removed.
	
	\param replace The object to replace.
	\param object The object to replace it with. */
- (void) replaceObjectIdenticalTo: (id)replace withObject: (id)object;

/*! \brief Replace an object identical to replace with the object.
	
	If replace is not in the array this is a nop.  If object is nil, then replace is simply removed.
	Matching is done with isEqual:.
	
	\param replace The object to replace.
	\param object The object to replace it with. */
- (void) replaceObject: (id) replace withObject: object;

@end

@interface NSArray(ASWArray_Deprecated)

/*! \brief Returns a NSArray of NSNumbers from a C-array.
 \param values pointer to the C-array.
 \param Number of UInt32s in values.
 \return An NSArray. */
+ (NSArray*) arrayWithUInt32Values: (UInt32*) values count: (NSUInteger) count  __attribute__((deprecated));

/*! \brief Returns a NSArray of NSNumbers from a C-array.
 \param values pointer to the C-array.
 \param Number of Float32 in values.
 \return An NSArray. */
+ (NSArray*) arrayWithFloat32Values: (Float32*) values count: (NSUInteger) count  __attribute__((deprecated));

/*! \brief Returns the closest matching value in the array.
 
 This is a fairly specific method, but I didn't want to put it somewhere else...and others may find it useful.
 
 \param desired The desired value. */
- (NSNumber*) closestNumberToNumber: (NSNumber*) desired  __attribute__((deprecated));

@end

@interface NSMutableArray(ASWArray_Deprecated)

/*! \brief Removes objects from this array.
 \deprecated Use the Cocoa-native -[NSMutableArray removeObjectsInArray:] instead.
 \param objects Remove the objects that are in this array. */
- (void) removeObjects: (NSArray*) objects  __attribute__((deprecated));

@end
