//
//  ASWStackCrawl.h
//  ASWDebug
//
//  Created by Matt Slot on 1/29/10.
//  Copyright 2010 Ambrosia Software, Inc.. All rights reserved.
//

#ifndef __ASW_STACK_CRAWL_HEADER__
#define __ASW_STACK_CRAWL_HEADER__

#import <Cocoa/Cocoa.h>

#define ASW_STACK_CRAWL_FRAMES		64

/*! \brief Generate a stack crawl for debugging.

	ASWStackCrawl provides a simple way to generate and dump a debugging
	stack crawl from anywhere in your application at runtime. The data can then
	be dumped to the console, to a file, or cached and examined later.
	
	NSLog(@"\n%@", [[ASWStackCrawl stackCrawl] asString]);
*/
@interface ASWStackCrawl : NSObject
{
	void *			mFrames[ASW_STACK_CRAWL_FRAMES];
	long			mNumFrames;
}

/*! \result An unretained stack crawl from the current point of execution.
	This object can be logged immediately, or retained and output later. */
+ (ASWStackCrawl *)stackCrawl;
/*! \result A user-friendly string describing a single stack crawl frame. */
+ (NSString *)stringForFrame:(void *)frame;

/*! \brief Designated initializer */
- (id)initWithFrames:(void **)frames count:(long)numFrames;

/*! \result An array of strings, one for each frame in the stack crawl. */
- (NSArray *)asStrings;
/*! \result A string describing all of the frames in the stack crawl. */
- (NSString *)asString;

@end

#endif /* __ASW_STACK_CRAWL_HEADER__ */
