//
//  ASWRetainLogging.h
//  ASWDebug
//
//  Created by Matt Slot on 5/11/10.
//  Copyright 2010 Ambrosia Software, Inc.. All rights reserved.
//

/* \brief Drop-in logging of retain/release/autorelease.

	This header is designed to be #import'ed directly into your class @implementation,
	so that it can override NSObject's retain/release/autorelease methods. Here's an
	example:
	
	...
	
	#import "ASWDebug/ASWStackCrawl.h"
	
	@implementation ASWWhizzyThing
	
	- (id)init
	{...}
	
	#import "ASWDebug/ASWRetainLogging.h"
	
	@end
	
*/

- (id)retain
{
	NSLog(@"<%s: %p> RETAIN %i -> %i\n%@", object_getClassName(self), self, 
			[self retainCount], [self retainCount] + 1, 
			[[[ASWStackCrawl stackCrawl] asString] 
				stringByReplacingOccurrencesOfString:@"\n" withString:@"\n\t"]);
	return [super retain];
}

- (oneway void)release
{
	NSLog(@"<%s: %p> RELEASE %i -> %i\n%@", object_getClassName(self), self, 
			[self retainCount], [self retainCount] - 1, 
			[[[ASWStackCrawl stackCrawl] asString] 
				stringByReplacingOccurrencesOfString:@"\n" withString:@"\n\t"]);
	[super release];
}

- (id)autorelease
{
	NSLog(@"<%s: %p> AUTORELEASE %i\n%@", object_getClassName(self), self, 
			[self retainCount], [[[ASWStackCrawl stackCrawl] asString] 
				stringByReplacingOccurrencesOfString:@"\n" withString:@"\n\t"]);
	return [super autorelease];
}

