//
//  ASWWorkspace.h
//  ASWAppKit
//
//  Created by Steve Streza on 3/26/10.
//  Copyright 2010 Ambrosia Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*! file ASWWorkspace.h */

/*! \brief An NSWorkspace category to move files to the Trash can */
@interface NSWorkspace (Trash)
/*! \brief Moves a file to the Trash can on the local volume
 *  \param filePath The path to the file
 *  \return YES if the file was moved successfully, NO otherwise
 */
-(BOOL)movePathToTrash:(NSString *)filePath;
@end
