//
//  ASWWindowTransformer.h
//  WindowCandy
//
//  Created by Andrew Welch on 8/25/05.
//  Copyright 2005 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*! \file ASWWindowTransformer.h */

/*! Types of window transformations */
typedef	enum ASWWindowTransformType
{
ASWWindowTestFadeInTransformer = 0,
ASWWindowTestFadeOutTransformer,
}	ASWWindowTransformType;

/*! Our notification that a transform has completed */
extern	NSString	*ASWWindowTransformCompleteKey;

/*! ASWWindowTransformer */
@interface ASWWindowTransformer : NSObject
{
/* -- Internal instance variables */

ASWWindowTransformType	animType;
NSTimer					*animTimer;
NSInteger				animWindowNumber;
NSWindow				*animWindow;
CGFloat					animDuration;
NSDate					*animTimeStarted;
NSInvocation			*animTransformProc;

/* -- Accessible instance variables */

NSRect					endingWindowRect;
BOOL					transformationIsActive;
}

/* -- Convenience class methods for creating ASWWindowTransformers */
/*! \brief Returns an autoreleased ASWWindowTransformer that fades in a window
	\param whichWindow window to transform
	\param whatDuration transform duration */
+ (ASWWindowTransformer *)fadeInTransformerWithWindow:(NSWindow *)whichWindow
					animationDurationSecs:(CGFloat)whatDuration;
/*! \brief Returns an autoreleased ASWWindowTransformer that fades out a window
	\param whichWindow window to transform
	\param whatDuration transform duration */
+ (ASWWindowTransformer *)fadeOutTransformerWithWindow:(NSWindow *)whichWindow
					animationDurationSecs:(CGFloat)whatDuration;

/* -- Designated initializer */
/*! \brief Initializes a new ASWWindowTransformer
	\param whichWindow window to transform
	\param whichType transform type
	\param whatDuration transform duration
	\return an initialized ASWWindowTransformer */
- (id)initWithWindow:(NSWindow *)whichWindow
		animationType:(ASWWindowTransformType)whichType
		animationDurationSecs:(CGFloat)whatDuration;

/* -- Starting and stopping a window transformation */
/*! \brief Start a window transformation */
- (void)startWindowTransformation;

/* -- Accessor methods */

- (void)setEndingWindowRect:(NSRect)whichRect;
- (NSRect)endingWindowRect;
- (BOOL)transformationIsActive;
- (NSWindow *)window;

@end
