//
//  ASWWindow.h
//  ASWAppKit
//
//  Created by Rudy Richter on 6/22/07.
//  Copyright 2007 Ambrosia Software, Inc. All rights reserved.
//

/*! \file ASWWindow.h */

#import <Cocoa/Cocoa.h>


/*! \brief Additions to NSWindow for stickiness, resizing and more
 \ingroup ASWAppKit */
@interface NSWindow (ASWWindow)

/*! \brief Returns all the views in the window */
- (NSMutableArray*)allViews;

/*! \brief Makes the NSWindow's first responder resign and become first responder again */
- (BOOL)endEditing;
/*! \brief Forces the first responder to resign */
- (void)forceEndEditing;

/*! \brief Resizes the receiver to the given size, keeping title bar where it is and keeping it centered if it's a sheet
 \param newSize The new size of the window
 \param animateFlag If it should animate the resizing, this is passed to -setFrame:animate:
 */
- (void)resizeToSize:(NSSize)newSize animate:(BOOL)animateFlag;
@end
