//
//  ASWView.h
//  WireTapPro2
//
//  Created by Dominic Feira on 6/2/06.
//  Copyright 2006 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

extern NSString* ASWViewWillMoveToSuperviewNotification;
extern NSString* ASWViewDidMoveToSuperviewNotification;
extern NSString* ASWViewSuperviewKey;

extern NSString* ASWViewWillMoveToWindowNotification;
extern NSString* ASWViewDidMoveToWindowNotification;
extern NSString* ASWViewWindowKey;

@interface ASWView : NSView 
{
	BOOL mAcceptsFirstMouse;
	BOOL mConsumeEvents;
}

/*! \brief YES if this view accepts first mouse */
- (BOOL) acceptsFirstMouse;

/*! \brief Set wether or not this view accepts first mouse */
- (void) setAcceptsFirstMouse: (BOOL) accepts;

/*! \brief Set wether or not this view should consume events
 
	If events are consumed the view acts like a black hole.  Events are chewed up.  They disappear from the responder chain */
- (void) setConsumeEvents: (BOOL) consume;

/*! \brief YES if events are consumed */
- (BOOL) consumeEvents;

/*! \brief Disable all controls that are descendents of this view */
- (void) setEnabled: (BOOL) enabled;
@end

@interface NSView (ASWView_Extensions)
/*! \brief Disable all controlsthat are descendents of this view */
- (void) viewSetEnabled: (BOOL) enabled;

/*! \brief Add all descendents of this view to the array */
- (void) addAllSubviewsToArray: (NSMutableArray *)array;

/*! \brief Remove all children */
- (void) removeAllSubviews;

/*! \brief Force this view to draw now. */
- (void) forceDraw;

/*! \brief Force this view to draw now.
	\param flipped Wether or not this view should be drawn flipped
	\param inverseTransform
	\param depth If zero draw all children.  Otherwise only go depth deep in the hierarchy */
- (void) forceDrawRecursiveIsAlreadyFlipped: (BOOL) flipped flipInverseTransform: (CGAffineTransform) inverseTransform depth: (NSUInteger) depth;
@end
