//
//  ASWTiledView.h
//  WTActivityWindow
//
//  Created by Mike Blaguszewski on 1/31/07.
//  Copyright 2007 Ambrosia Software, Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*! \brief Tiling view, possibly not even used by ASWActivityView though...
	\ingroup ASWAppKit */
@interface ASWTiledView : NSView
{
	BOOL mPerformingLayout;
	BOOL mResizing;
	BOOL mUseAlternatingRowColors;
	NSMutableArray *mOrderedSubviews;
}

/*! \brief Adds a subview to the tile view, will trigger layout */
- (void)addSubview:(NSView *)view;
/*! \brief Returns YES if the background colors alternate */
- (BOOL)usesAlternatingRowBackgroundColors;
/*! \brief Tells the receiver if the background colors should alternate */
- (void)setUsesAlternatingRowBackgroundColors:(BOOL)useAlternatingRowColors;

/*! \brief Internally used to layout the subviews in a tiled manner
	\private */
- (void)_performLayout;
@end
