//
//  ASWTextViewer.h
//  ASWFoundation
//
//  Created by Dominic Feira on 1/9/07.
//  Copyright 2007 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*! \file ASWTextViewer.h */

/*! ASWTextViewer */
@interface ASWTextViewer : NSWindowController 
{
	NSString* mPath;
	IBOutlet NSTextView* mTextView;
}
/*! \brief Creates a new ASWTextViewer with a file
	\param path path to a file
	\return initialized ASWTextViewer */
- (id) initWithPath: (NSString*) path;
/*! \brief Set the window's title
	\param title window title*/
- (void) setTitle: (NSString*) title;
/*! \brief Print the text view
	\param sender sender */
- (IBAction) printDocument: (id) sender;
@end
