//
//  ASWSplashScreen.h
//  ASWAppKit
//
//  Created by rudy on 4/17/08.
//  Copyright 2008 Ambrosia Software, Inc. All rights reserved.
//

/*! \file ASWSplashScreen.h */


#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>

#define kASWSplashScreenOnStartupKey @"ASWSplashScreenOnStartup"

@class ASWSplashScreen;

extern NSString *ASWSplashScreenHasVideos;
extern NSString *ASWSplashScreenHasShowOnLaunch;

@protocol ASWSplashScreenDelegate
- (IBAction)launchVideoURL:(id)sender;
- (IBAction)launchWebSiteURL:(id)sender;
- (void)splashScreenWillClose;
- (void)splashScreenDidClose;
- (void)splashScreen: (ASWSplashScreen*) splashScreen didFinishLoadingURL: (NSURL*) url;
@end

/*! ASWSplashScreen */
@interface ASWSplashScreen : NSWindowController 
{
	BOOL _shouldDisplayVideoButton;
	BOOL _shouldDisplayShowOnLaunchCheckbox;
	BOOL _shouldDisplayWebSiteButton;
	
	BOOL _isSheet;
	
	id<ASWSplashScreenDelegate> mDelegate;
	
	IBOutlet NSButton *_videoButton;
	IBOutlet NSButton *_showOnLaunchCheckbox;
	IBOutlet NSButton *_websiteButton;
	IBOutlet NSButton *_doneButton;
	IBOutlet WebView  *_webView;
	NSURL* _URL;
}

+ (ASWSplashScreen*)sharedController;

- (id)initWithWindowNibName:(NSString*)nibName;
- (id)initWithWindowNibPath:(NSString *)windowNibPath;

- (void) setURL: (NSURL*) url;
- (NSURL*) URL;
- (void) loadURL;


- (void)runModal;

- (void) beginSheetModalForWindow: (NSWindow*) docWindow 
					modalDelegate: (id) modalDelegate didEndSelector: (SEL) didEndSelector 
					  contextInfo: (void*) contextInfo;


- (void)run;
- (void)close;
- (void)setDelegate:(id<ASWSplashScreenDelegate>)delegate;
- (id<ASWSplashScreenDelegate>)delegate;
- (void)setShouldShowVideos:(BOOL)should;
- (void)setShouldShowSplashScreen:(BOOL)should;
- (void)setShouldShowWebSite:(BOOL)should;

- (IBAction)launchVideosURL:(id)sender;
- (IBAction)launchWebSiteURL:(id)sender;
- (IBAction)done:(id)sender;

@end
