//
//  ASWSliderCell.h
//  ASWAppKit
//
//  Created by rudy on 1/3/08.
//  Copyright 2008 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*! \file ASWSliderCell.h */

/*! ASWSliderCell */
@interface ASWSliderCell : NSSliderCell
{
	NSImage *_barImage;
	NSImage *_knobImage;
	NSImage *_tickImage;
	
	BOOL _isVertical;
}
/*! \brief Set the tick image
	\param image tick image */
- (void)setTickImage:(NSImage*)image;
/* \brief Get the tick image
	\param the tick image */
- (NSImage*)tickImage;

/*! \brief Set if the slider is vertical */
-(void)setVertical:(BOOL)vert;

- (NSRect) barRect;
@end
