//
//  ASWSlider.h
//  ASWAppKit
//
//  Created by rudy on 1/2/08.
//  Copyright 2008 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*! \file ASWSlider.h */

/*! ASWSlider */
@interface ASWSlider : NSSlider 
{
	IBOutlet id _delegate;
}
/*! \brief Sets the cell class to ASWSliderCell */
+ (void)initialize;
/*! \brief Create a new ASWSlider
	\param frame frame */
- (id)initWithFrame:(NSRect)frame;
/*! \brief Set the delegate
	\param delegate delegate */
- (void)setDelegate:(id)delegate;
/*! \brief Get the delegate
	\return delegate */
- (id)delegate;
/*! \brief Handle mouse down
	\param event mouse down event */
- (void)mouseDown:(NSEvent*)event;
/*! \brief Notifies the delegate when sliding begins */
- (void)beginSlide;
/*! \brief Notifies the delegate when sliding ends */
- (void)endSlide;
/*! \brief Set the tick image
	\param image tick image*/
- (void)setTickImage:(NSImage*)image;
/*! \brief Get the tick image
	\return the tick image */
- (NSImage*)tickImage;
/*! \brief Set the bar image
	\param image bar image */
- (void)setBarImage:(NSImage*)image;
/*! \brief Get the bar image
	\return the bar image */
- (NSImage*)barImage;
/*! \brief Set the knob image
	\param image knob image */
- (void)setKnobImage:(NSImage*)image;
/*! \brief Get the knob image
	\return the knob image */
- (NSImage*)knobImage;
/*! \brief Set up the slider cell */
- (void)setupCustomCell;

@end

@interface NSObject (ASWSliderDelegate)
/*! \brief Message send to delegate when a slider starts changing */
- (void) sliderDidBegin: (ASWSlider*) slider;

/*! \brief Message send to delegate when a slider completes changing */
- (void) sliderDidEnd: (ASWSlider*) slider;
@end
