//
//  ASWShadow.h
//  ASWAppKit
//
//  Created by Matt Slot on 8/22/08.
//  Copyright 2008 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <AppKit/AppKit.h>

/*! \brief NSShaddow additions
	\ingroup ASWAppKit */
@interface NSShadow (ASWShadow_Additions)

/*! \brief Convenience method for creating a new shadow given color, offset & radius
	\param shadowColor NSColor for the shadow
	\param shadowOffset How far offset the shadow should be
	\param shadowBlurRadius How much the shadow is blurred 
	\return Autoreleased NSShadow with given properties */
+ (NSShadow *)shadowWithColor:(NSColor *)shadowColor
		offset:(NSSize)shadowOffset blurRadius:(CGFloat)shadowBlurRadius;

@end
