//
//  ASWRootShell.h
//  Dragster
//
//  Created by Michael Blaguszewski on 3/30/06.
//  Copyright 2006 Ambrosia Software, Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <Security/Security.h>

/*! \file ASWRootShell.h */

/*! ASWRootShell */
@interface ASWRootShell : NSObject
{
	AuthorizationRef mAuthorizationRef;
}
/*! \brief Initializes a new ASWRootShell
	
	User interaction happens here, so could return nil
	
	\return a new ASWRootShell (can return nil) */
- (id)init;

/*! \brief Execute a command with arguments
	\param command command to execute
	\param arguments arguments to pass to the command
	\return true if the command runs successfully */
- (BOOL)executeCommand:(const char *)command withArguments:(char * const *)arguments;
/*! \brief Execute a command with arguments, returning an error code
	\param command command to execute
	\param arguments arguments to pass to the command
	\return error code from AuthorizationExecuteWithPrivileges */
- (OSStatus)executeCommandReturningError:(const char *)command withArguments:(char * const *)arguments;
@end
