//
//  ASWPreferencesViewController.h
//  ASWInterface
//
//  Created by Steve Streza on 12/18/09.
//  Copyright 2009 Ambrosia Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "ASWPreferencesController.h"

/** \file ASWPreferencesViewController.h
 *  \class ASWPreferencesViewController
 *  \brief A view controller for an individual tab in a preferences window.
 *
 *  ASWPreferencesViewController is an abstract superclass for views to be
 *  presented in a preferences window. To use, you must subclass the
 *  ASWPreferencesViewController and implement some of the methods. After
 *  doing this, you can add the subclass to ASWPreferencesController, and
 *  when the user displays the preferences window, the views will get
 *  loaded automatically and added to the window.
 */
@interface ASWPreferencesViewController : NSViewController<ASWPreferencesControllerProtocol> {
	NSToolbarItem *toolbarItem;
	NSImage *toolbarImage;

	NSString* title;
	BOOL mEnabled;
}

/*! \brief The toolbar item representing this view controller in the preferences window. 
 *  \note This is created automatically for you.
 */
@property (retain) NSToolbarItem *toolbarItem;

/*! \brief The image on the toolbar item representing this view controller in the preferences window. */
@property (readonly) NSImage *toolbarImage;

/*! \brief Marks the view controller as enabled or disabled in the preferences window. */
@property (nonatomic, assign, getter=isEnabled) BOOL enabled;

/*! \brief Name of the image to be loaded out of the application bundle for this view controller */
@property (readonly) NSString *toolbarImageName;

/*! \brief The name of the nib to load the view from. */
@property (readonly) NSString *nibName;

/*! \brief The name on the toolbar item representing this view controller in the preferences window.  */
@property (readonly) NSString *title;


/*! \brief The size of the view
 *
 *  \note Size of the content area. This is called whenever the view is
 *        added to the window, or the user selects the tab. The NSWindow
 *        will automatically animate to the size returned here.
 */
-(NSSize)contentSize;

/*! \brief Gets called before the view appears
 *
 *  \note  These get called by ASWPreferencesController as different view
 *         controllers are displayed/hidden. Override in your subclass.
 *         Default implementation does nothing.
 */
-(void)viewWillAppear;

/*! \brief Gets called after the view appears
 *
 *  \note  These get called by ASWPreferencesController as different view
 *         controllers are displayed/hidden. Override in your subclass.
 *         Default implementation does nothing.
 */
-(void)viewDidAppear;

/*! \brief Gets called before the view disappears
 *
 *  \note  These get called by ASWPreferencesController as different view
 *         controllers are displayed/hidden. Override in your subclass.
 *         Default implementation does nothing.
 */
-(void)viewWillDisappear;

/*! \brief Gets called after the view disappears
 *
 *  \note  These get called by ASWPreferencesController as different view
 *         controllers are displayed/hidden. Override in your subclass.
 *         Default implementation does nothing.
 */
-(void)viewDidDisappear;

/*! @} */

@end
