//
//  ASWPopUpButtonCell.h
//  ASWAppKit
//
//  Created by rudy on 1/18/08.
//  Copyright 2008 Ambrosia Software, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "ASWCustomMenuWindow.h"

@interface ASWPopUpButtonCell : NSPopUpButtonCell 
{
	NSMenu	*_realMenu;
	Class	_menuWindowClass;
	NSImage *_enabledImage;
	NSImage *_disabledImage;
	NSImage *_checkImage;
	NSDictionary *_titleAttributes;
	NSSize _leftCap;
	NSSize _rightCap;
	id _menuWindow;
	
	NSSize shadowSize;
}

- (id)init;
- (void)dealloc;
- (void)drawWithFrame:(NSRect)cellFrame inView:(NSView *)controlView;
- (NSImage*)enabledImage;
- (void)setEnabledImage:(NSImage*)enabledImage;
- (NSImage*)disabledImage;
- (void)setDisabledImage:(NSImage*)disabledImage;
- (NSImage*)checkImage;
- (void)setCheckImage:(NSImage*)checkImage;
- (NSDictionary*)titleAttributes;
- (void)setTitleAttributes:(NSDictionary*)titleAttributes;

- (void)setLeftCapSize:(NSSize)size;
- (NSSize)leftCapSize;

- (void)setRightCapSize:(NSSize)size;
- (NSSize)rightCapSize;

- (void)setShadowSize:(NSSize)size;
- (NSSize)shadowSize;

- (void)setMenuWindowClass:(Class)menuWindowClass;

@property (nonatomic, assign) NSSize shadowSize;
@end
